/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.util;

import net.imprex.shaded.org.jetbrains.annotations.NotNull;

public record NamespacedKey(String namespace, String key) {
    public static final String MINECRAFT = "minecraft";

    @Deprecated
    public NamespacedKey(String namespace, String key) {
        if (namespace == null || !NamespacedKey.isValidNamespace(namespace)) {
            throw new IllegalArgumentException(String.format("Invalid namespace. Must be [a-z0-9._-]: %s", namespace));
        }
        if (key == null || !NamespacedKey.isValidKey(key)) {
            throw new IllegalArgumentException(String.format("Invalid key. Must be [a-z0-9/._-]: %s", key));
        }
        this.namespace = namespace;
        this.key = key;
        String string = this.toString();
        if (string.length() >= 256) {
            throw new IllegalArgumentException(String.format("NamespacedKey must be less than 256 characters (%s)", string));
        }
    }

    private static boolean isValidNamespaceChar(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '.' || c == '_' || c == '-';
    }

    private static boolean isValidKeyChar(char c) {
        return NamespacedKey.isValidNamespaceChar(c) || c == '/';
    }

    private static boolean isValidNamespace(String namespace) {
        int len = namespace.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (NamespacedKey.isValidNamespaceChar(namespace.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidKey(String key) {
        int len = key.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (NamespacedKey.isValidKeyChar(key.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamespacedKey other = (NamespacedKey)obj;
        return this.namespace.equals(other.namespace) && this.key.equals(other.key);
    }

    @Override
    public String toString() {
        return this.namespace + ":" + this.key;
    }

    public static NamespacedKey minecraft(String key) {
        return new NamespacedKey(MINECRAFT, key);
    }

    public static NamespacedKey fromString(@NotNull String string) {
        String key;
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Input string must not be empty or null");
        }
        String[] components = string.split(":", 3);
        if (components.length > 2) {
            return null;
        }
        String string2 = key = components.length == 2 ? components[1] : "";
        if (components.length == 1) {
            String value = components[0];
            if (value.isEmpty() || !NamespacedKey.isValidKey(value)) {
                return null;
            }
            return NamespacedKey.minecraft(value);
        }
        if (components.length == 2 && !NamespacedKey.isValidKey(key)) {
            return null;
        }
        String namespace = components[0];
        if (namespace.isEmpty()) {
            return NamespacedKey.minecraft(key);
        }
        if (!NamespacedKey.isValidNamespace(namespace)) {
            return null;
        }
        return new NamespacedKey(namespace, key);
    }
}

