/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketListener;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import dev.imprex.orebfuscator.logging.OfcLogger;
import dev.imprex.orebfuscator.util.JavaVersion;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.imprex.orebfuscator.Orebfuscator;
import net.imprex.orebfuscator.iterop.BukkitWorldAccessor;
import net.imprex.orebfuscator.util.MinecraftVersion;
import net.imprex.orebfuscator.util.PermissionUtil;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;

public class OrebfuscatorCommand
implements CommandExecutor,
TabCompleter {
    private static final List<String> TAB_COMPLETE = Arrays.asList("dump");
    private final DateTimeFormatter fileFormat = DateTimeFormatter.ofPattern("uuuu-MM-dd_HH.mm.ss");
    private final DateTimeFormatter timeFormat = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    private final Orebfuscator orebfuscator;

    public OrebfuscatorCommand(Orebfuscator orebfuscator) {
        this.orebfuscator = orebfuscator;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!command.getName().equalsIgnoreCase("orebfuscator")) {
            sender.sendMessage("Incorrect command registered!");
            return false;
        }
        if (!PermissionUtil.canAccessAdminTools((Permissible)sender)) {
            sender.sendMessage("You don't have the 'orebfuscator.admin' permission.");
            return false;
        }
        if (args.length == 0) {
            sender.sendMessage("You are using " + this.orebfuscator.toString());
            sender.sendMessage(this.orebfuscator.getStatistics().toString());
        } else if (args[0].equalsIgnoreCase("dump")) {
            OffsetDateTime now = OffsetDateTime.now(ZoneOffset.UTC);
            JsonObject root = new JsonObject();
            root.addProperty("timestamp", this.timeFormat.format(now));
            JsonObject versions = new JsonObject();
            versions.addProperty("java", Integer.toString(JavaVersion.get()));
            versions.addProperty("nms", MinecraftVersion.nmsVersion());
            versions.addProperty("server", Bukkit.getVersion());
            versions.addProperty("bukkit", Bukkit.getBukkitVersion());
            versions.addProperty("protocolLib", ProtocolLibrary.getPlugin().toString());
            versions.addProperty("orebfuscator", this.orebfuscator.toString());
            root.add("versions", (JsonElement)versions);
            root.add("statistics", (JsonElement)this.orebfuscator.getStatistics().toJson());
            JsonObject plugins = new JsonObject();
            for (Plugin bukkitPlugin : Bukkit.getPluginManager().getPlugins()) {
                PluginDescriptionFile description = bukkitPlugin.getDescription();
                JsonObject plugin = new JsonObject();
                plugin.addProperty("version", description.getVersion());
                plugin.addProperty("author", description.getAuthors().toString());
                plugins.add(bukkitPlugin.getName(), (JsonElement)plugin);
            }
            root.add("plugins", (JsonElement)plugins);
            JsonObject worlds = new JsonObject();
            for (World bukkitWorld : Bukkit.getWorlds()) {
                JsonObject world = new JsonObject();
                world.addProperty("uuid", bukkitWorld.getUID().toString());
                world.addProperty("heightAccessor", BukkitWorldAccessor.get(bukkitWorld).toString());
                worlds.add(bukkitWorld.getName(), (JsonElement)world);
            }
            root.add("worlds", (JsonElement)worlds);
            JsonObject listeners = new JsonObject();
            for (PacketListener packetListener : ProtocolLibrary.getProtocolManager().getPacketListeners()) {
                JsonObject listener = new JsonObject();
                listener.addProperty("plugin", packetListener.getPlugin().toString());
                listener.addProperty("receivingWhitelist", packetListener.getSendingWhitelist().toString());
                listener.addProperty("sendingWhitelist", packetListener.getSendingWhitelist().toString());
                String key = packetListener.getClass().toGenericString() + "@" + System.identityHashCode(packetListener);
                listeners.add(key, (JsonElement)listener);
            }
            root.add("listeners", (JsonElement)listeners);
            root.add("blocks", (JsonElement)this.orebfuscator.getOrebfuscatorConfig().toJson());
            Base64.Encoder encoder = Base64.getUrlEncoder();
            String latestLog = OfcLogger.getLatestVerboseLog();
            root.addProperty("verboseLog", encoder.encodeToString(latestLog.getBytes(StandardCharsets.UTF_8)));
            try {
                Path configPath = this.orebfuscator.getDataFolder().toPath().resolve("config.yml");
                String config = Files.readAllLines(configPath).stream().collect(Collectors.joining("\n"));
                root.addProperty("config", encoder.encodeToString(config.getBytes(StandardCharsets.UTF_8)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String configReport = this.orebfuscator.getOrebfuscatorConfig().report();
            configReport = configReport != null ? configReport : "";
            root.addProperty("configReport", encoder.encodeToString(configReport.getBytes(StandardCharsets.UTF_8)));
            Path path = this.orebfuscator.getDataFolder().toPath().resolve("dump-" + this.fileFormat.format(now) + ".json");
            try (JsonWriter writer = new JsonWriter((Writer)Files.newBufferedWriter(path, new OpenOption[0]));){
                writer.setIndent("  ");
                Streams.write((JsonElement)root, (JsonWriter)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            sender.sendMessage("Dump file created at: " + String.valueOf(path));
        } else {
            return false;
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return args.length == 1 ? TAB_COMPLETE : Collections.emptyList();
    }
}

