/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator.cache;

import dev.imprex.orebfuscator.cache.AbstractRegionFileCache;
import dev.imprex.orebfuscator.logging.OfcLogger;
import dev.imprex.orebfuscator.util.ChunkCacheKey;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.imprex.orebfuscator.Orebfuscator;
import net.imprex.orebfuscator.cache.CacheChunkEntry;
import net.imprex.orebfuscator.cache.ChunkSerializer;
import net.imprex.shaded.org.jetbrains.annotations.NotNull;

public class AsyncChunkSerializer
implements Runnable {
    private final Lock lock = new ReentrantLock(true);
    private final Condition notFull = this.lock.newCondition();
    private final Condition notEmpty = this.lock.newCondition();
    private final Map<ChunkCacheKey, Runnable> tasks = new HashMap<ChunkCacheKey, Runnable>();
    private final Queue<ChunkCacheKey> positions = new LinkedList<ChunkCacheKey>();
    private final int maxTaskQueueSize;
    private final ChunkSerializer serializer;
    private final Thread thread;
    private volatile boolean running = true;

    public AsyncChunkSerializer(Orebfuscator orebfuscator, AbstractRegionFileCache<?> regionFileCache) {
        this.maxTaskQueueSize = orebfuscator.getOrebfuscatorConfig().cache().maximumTaskQueueSize();
        this.serializer = new ChunkSerializer(regionFileCache);
        this.thread = new Thread(Orebfuscator.THREAD_GROUP, this, "ofc-chunk-serializer");
        this.thread.setDaemon(true);
        this.thread.start();
        orebfuscator.getStatistics().setDiskCacheQueueLengthSupplier(this.tasks::size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompletableFuture<CacheChunkEntry> read(@NotNull ChunkCacheKey key) {
        this.lock.lock();
        try {
            Runnable task = this.tasks.get(key);
            if (task instanceof WriteTask) {
                CompletableFuture<CacheChunkEntry> completableFuture = CompletableFuture.completedFuture(((WriteTask)task).chunk);
                return completableFuture;
            }
            if (task instanceof ReadTask) {
                CompletableFuture<CacheChunkEntry> completableFuture = ((ReadTask)task).future;
                return completableFuture;
            }
            CompletableFuture<CacheChunkEntry> future = new CompletableFuture<CacheChunkEntry>();
            this.queueTask(key, new ReadTask(key, future));
            CompletableFuture<CacheChunkEntry> completableFuture = future;
            return completableFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(@NotNull ChunkCacheKey key, @NotNull CacheChunkEntry chunk) {
        this.lock.lock();
        try {
            Runnable prevTask = this.queueTask(key, new WriteTask(key, chunk));
            if (prevTask instanceof ReadTask) {
                ((ReadTask)prevTask).future.complete(chunk);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @NotNull
    private Runnable queueTask(@NotNull ChunkCacheKey key, @NotNull Runnable nextTask) {
        while (this.positions.size() >= this.maxTaskQueueSize) {
            this.notFull.awaitUninterruptibly();
        }
        if (!this.running) {
            throw new IllegalStateException("AsyncChunkSerializer already closed");
        }
        Runnable prevTask = this.tasks.put(key, nextTask);
        if (prevTask == null) {
            this.positions.offer(key);
        }
        this.notEmpty.signal();
        return prevTask;
    }

    @Override
    public void run() {
        while (this.running) {
            this.lock.lock();
            try {
                while (this.positions.isEmpty()) {
                    this.notEmpty.await();
                }
                this.tasks.remove(this.positions.poll()).run();
                this.notFull.signal();
            }
            catch (InterruptedException e) {
                break;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void close() {
        this.lock.lock();
        try {
            this.running = false;
            this.thread.interrupt();
            while (!this.positions.isEmpty()) {
                Runnable task = this.tasks.remove(this.positions.poll());
                if (!(task instanceof WriteTask)) continue;
                task.run();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private class WriteTask
    implements Runnable {
        private final ChunkCacheKey key;
        private final CacheChunkEntry chunk;

        public WriteTask(ChunkCacheKey key, CacheChunkEntry chunk) {
            this.key = key;
            this.chunk = chunk;
        }

        @Override
        public void run() {
            try {
                AsyncChunkSerializer.this.serializer.write(this.key, this.chunk);
            }
            catch (IOException e) {
                OfcLogger.error(e);
            }
        }
    }

    private class ReadTask
    implements Runnable {
        private final ChunkCacheKey key;
        private final CompletableFuture<CacheChunkEntry> future;

        public ReadTask(ChunkCacheKey key, CompletableFuture<CacheChunkEntry> future) {
            this.key = key;
            this.future = future;
        }

        @Override
        public void run() {
            try {
                this.future.complete(AsyncChunkSerializer.this.serializer.read(this.key));
            }
            catch (IOException e) {
                this.future.completeExceptionally(e);
            }
        }
    }
}

