/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator.nms.v1_18_R1;

import com.comphenix.protocol.events.PacketContainer;
import com.google.common.collect.ImmutableList;
import dev.imprex.orebfuscator.cache.AbstractRegionFileCache;
import dev.imprex.orebfuscator.config.api.Config;
import dev.imprex.orebfuscator.util.BlockPos;
import dev.imprex.orebfuscator.util.BlockProperties;
import dev.imprex.orebfuscator.util.BlockStateProperties;
import dev.imprex.orebfuscator.util.BlockTag;
import dev.imprex.orebfuscator.util.NamespacedKey;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import net.imprex.orebfuscator.nms.AbstractNmsManager;
import net.imprex.orebfuscator.nms.ReadOnlyChunk;
import net.imprex.orebfuscator.nms.v1_18_R1.ReadOnlyChunkWrapper;
import net.imprex.orebfuscator.nms.v1_18_R1.RegionFileCache;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutMultiBlockChange;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class NmsManager
extends AbstractNmsManager {
    private static final int BLOCK_ID_AIR = Block.i((IBlockData)Blocks.a.n());

    static int getBlockState(Chunk chunk, int x, int y, int z) {
        ChunkSection section;
        ChunkSection[] sections = chunk.d();
        int sectionIndex = chunk.e(y);
        if (sectionIndex >= 0 && sectionIndex < sections.length && (section = sections[sectionIndex]) != null && !section.c()) {
            return Block.i((IBlockData)section.a(x & 0xF, y & 0xF, z & 0xF));
        }
        return BLOCK_ID_AIR;
    }

    private static WorldServer level(World world) {
        return NmsManager.worldHandle(world, WorldServer.class);
    }

    private static EntityPlayer player(Player player) {
        return NmsManager.playerHandle(player, EntityPlayer.class);
    }

    public NmsManager() {
        super(Block.p.b());
        NamespacedKey namespacedKey;
        for (Map.Entry entry : IRegistry.X.e()) {
            namespacedKey = NamespacedKey.fromString(((ResourceKey)entry.getKey()).a().toString());
            Block block = (Block)entry.getValue();
            ImmutableList possibleBlockStates = block.m().a();
            BlockProperties.Builder builder = BlockProperties.builder(namespacedKey);
            for (IBlockData blockState : possibleBlockStates) {
                BlockStateProperties properties = BlockStateProperties.builder(Block.i((IBlockData)blockState)).withIsAir(blockState.g()).withIsOccluding(blockState.i((IBlockAccess)BlockAccessAir.a, BlockPosition.b)).withIsBlockEntity(blockState.m()).withIsDefaultState(Objects.equals(block.n(), blockState)).build();
                builder.withBlockState(properties);
            }
            this.registerBlockProperties(builder.build());
        }
        for (Map.Entry entry : TagsBlock.a().a().entrySet()) {
            namespacedKey = NamespacedKey.fromString(((MinecraftKey)entry.getKey()).toString());
            HashSet<BlockProperties> blocks = new HashSet<BlockProperties>();
            for (Block block : ((Tag)entry.getValue()).b()) {
                BlockProperties properties = this.getBlockByName(IRegistry.X.b((Object)block).toString());
                if (properties == null) continue;
                blocks.add(properties);
            }
            this.registerBlockTag(new BlockTag(namespacedKey, blocks));
        }
    }

    @Override
    public AbstractRegionFileCache<?> createRegionFileCache(Config config) {
        return new RegionFileCache(config.cache());
    }

    @Override
    public ReadOnlyChunk getReadOnlyChunk(World world, int chunkX, int chunkZ) {
        ChunkProviderServer serverChunkCache = NmsManager.level(world).k();
        Chunk chunk = serverChunkCache.a(chunkX, chunkZ, true);
        return new ReadOnlyChunkWrapper(chunk);
    }

    @Override
    public int getBlockState(World world, int x, int y, int z) {
        ChunkProviderServer serverChunkCache = NmsManager.level(world).k();
        if (!serverChunkCache.isChunkLoaded(x >> 4, z >> 4)) {
            return BLOCK_ID_AIR;
        }
        Chunk chunk = serverChunkCache.a(x >> 4, z >> 4, true);
        if (chunk == null) {
            return BLOCK_ID_AIR;
        }
        return NmsManager.getBlockState(chunk, x, y, z);
    }

    @Override
    public void sendBlockUpdates(World world, Iterable<BlockPos> iterable) {
        ChunkProviderServer serverChunkCache = NmsManager.level(world).k();
        BlockPosition.MutableBlockPosition position = new BlockPosition.MutableBlockPosition();
        for (BlockPos pos : iterable) {
            position.d(pos.x(), pos.y(), pos.z());
            serverChunkCache.a((BlockPosition)position);
        }
    }

    @Override
    public void sendBlockUpdates(Player player, Iterable<BlockPos> iterable) {
        EntityPlayer serverPlayer = NmsManager.player(player);
        WorldServer level = serverPlayer.x();
        ChunkProviderServer serverChunkCache = level.k();
        BlockPosition.MutableBlockPosition position = new BlockPosition.MutableBlockPosition();
        HashMap<SectionPosition, Short2ObjectMap> sectionPackets = new HashMap<SectionPosition, Short2ObjectMap>();
        ArrayList<Packet> blockEntityPackets = new ArrayList<Packet>();
        for (BlockPos blockPos : iterable) {
            TileEntity blockEntity;
            if (!serverChunkCache.isChunkLoaded(blockPos.x() >> 4, blockPos.z() >> 4)) continue;
            position.d(blockPos.x(), blockPos.y(), blockPos.z());
            IBlockData blockState = level.a_((BlockPosition)position);
            sectionPackets.computeIfAbsent(SectionPosition.a((BlockPosition)position), key -> new Short2ObjectOpenHashMap()).put(SectionPosition.b((BlockPosition)position), (Object)blockState);
            if (!blockState.m() || (blockEntity = level.c_((BlockPosition)position)) == null) continue;
            blockEntityPackets.add(blockEntity.h());
        }
        for (Map.Entry entry : sectionPackets.entrySet()) {
            Short2ObjectMap blockStates = (Short2ObjectMap)entry.getValue();
            if (blockStates.size() == 1) {
                Short2ObjectMap.Entry blockEntry = (Short2ObjectMap.Entry)blockStates.short2ObjectEntrySet().iterator().next();
                BlockPosition blockPosition = ((SectionPosition)entry.getKey()).g(blockEntry.getShortKey());
                serverPlayer.b.a((Packet)new PacketPlayOutBlockChange(blockPosition, (IBlockData)blockEntry.getValue()));
                continue;
            }
            PacketContainer packet = PacketContainer.fromPacket((Object)new PacketPlayOutMultiBlockChange((SectionPosition)entry.getKey(), blockStates.keySet(), null, false));
            packet.getSpecificModifier(IBlockData[].class).write(0, (Object)((IBlockData[])blockStates.values().toArray(IBlockData[]::new)));
            serverPlayer.b.a((Packet)packet.getHandle());
        }
        for (Packet packet : blockEntityPackets) {
            serverPlayer.b.a(packet);
        }
    }
}

