/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator.obfuscation;

import com.google.common.collect.Iterables;
import dev.imprex.orebfuscator.config.OrebfuscatorConfig;
import dev.imprex.orebfuscator.config.api.BlockFlags;
import dev.imprex.orebfuscator.config.api.ObfuscationConfig;
import dev.imprex.orebfuscator.config.api.WorldConfigBundle;
import dev.imprex.orebfuscator.util.BlockPos;
import dev.imprex.orebfuscator.util.ChunkCacheKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.imprex.orebfuscator.Orebfuscator;
import net.imprex.orebfuscator.OrebfuscatorNms;
import net.imprex.orebfuscator.cache.ObfuscationCache;
import net.imprex.orebfuscator.iterop.BukkitWorldAccessor;
import org.bukkit.World;
import org.bukkit.block.Block;

public class DeobfuscationWorker {
    private final OrebfuscatorConfig config;
    private final ObfuscationCache cache;

    public DeobfuscationWorker(Orebfuscator orebfuscator) {
        this.config = orebfuscator.getOrebfuscatorConfig();
        this.cache = orebfuscator.getObfuscationCache();
    }

    void deobfuscate(Block block) {
        if (block == null || !block.getType().isOccluding()) {
            return;
        }
        this.deobfuscate(Arrays.asList(block), true);
    }

    public void deobfuscate(Collection<? extends Block> blocks, boolean occluding) {
        if (blocks.isEmpty()) {
            return;
        }
        World world = ((Block)Iterables.get(blocks, (int)0)).getWorld();
        BukkitWorldAccessor worldAccessor = BukkitWorldAccessor.get(world);
        WorldConfigBundle bundle = this.config.world(worldAccessor);
        ObfuscationConfig obfuscationConfig = bundle.obfuscation();
        if (obfuscationConfig == null || !obfuscationConfig.isEnabled()) {
            return;
        }
        int updateRadius = this.config.general().updateRadius();
        BlockFlags blockFlags = bundle.blockFlags();
        try (Processor processor = new Processor(worldAccessor, blockFlags);){
            for (Block block : blocks) {
                if (occluding && !block.getType().isOccluding()) continue;
                BlockPos position = new BlockPos(block.getX(), block.getY(), block.getZ());
                processor.processPosition(position, updateRadius);
            }
        }
    }

    public class Processor
    implements AutoCloseable {
        private final Set<BlockPos> updatedBlocks = new HashSet<BlockPos>();
        private final Set<ChunkCacheKey> invalidChunks = new HashSet<ChunkCacheKey>();
        private final BukkitWorldAccessor worldAccessor;
        private final BlockFlags blockFlags;

        public Processor(BukkitWorldAccessor worldAccessor, BlockFlags blockFlags) {
            this.worldAccessor = worldAccessor;
            this.blockFlags = blockFlags;
        }

        public void processPosition(BlockPos position, int depth) {
            ChunkCacheKey chunkPosition;
            int blockId = OrebfuscatorNms.getBlockState(this.worldAccessor.world, position);
            if (BlockFlags.isObfuscateBitSet(this.blockFlags.flags(blockId)) && this.updatedBlocks.add(position) && DeobfuscationWorker.this.config.cache().enabled() && this.invalidChunks.add(chunkPosition = new ChunkCacheKey(this.worldAccessor, position))) {
                DeobfuscationWorker.this.cache.invalidate(chunkPosition);
            }
            if (depth-- > 0) {
                this.processPosition(position.add(1, 0, 0), depth);
                this.processPosition(position.add(-1, 0, 0), depth);
                this.processPosition(position.add(0, 1, 0), depth);
                this.processPosition(position.add(0, -1, 0), depth);
                this.processPosition(position.add(0, 0, 1), depth);
                this.processPosition(position.add(0, 0, -1), depth);
            }
        }

        @Override
        public void close() {
            OrebfuscatorNms.sendBlockUpdates(this.worldAccessor.world, this.updatedBlocks);
        }
    }
}

