/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator.proximity;

import dev.imprex.orebfuscator.config.api.AdvancedConfig;
import dev.imprex.orebfuscator.logging.OfcLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import net.imprex.orebfuscator.Orebfuscator;
import net.imprex.orebfuscator.OrebfuscatorStatistics;
import net.imprex.orebfuscator.proximity.ProximityWorker;
import net.imprex.orebfuscator.proximity.ProximityWorkerThread;
import net.imprex.orebfuscator.util.RingTimer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class ProximityDirectorThread
extends Thread
implements Listener {
    private final Orebfuscator orebfuscator;
    private final int workerCount;
    private final int defaultBucketSize;
    private final long checkInterval;
    private final Phaser phaser = new Phaser(1);
    private volatile boolean running = true;
    private final ProximityWorker worker;
    private final ProximityWorkerThread[] workerThreads;
    private final BlockingQueue<List<Player>> bucketQueue = new LinkedBlockingQueue<List<Player>>();
    private final RingTimer waitTimer = new RingTimer(100);
    private final RingTimer processTimer = new RingTimer(100);

    public ProximityDirectorThread(Orebfuscator orebfuscator) {
        super(Orebfuscator.THREAD_GROUP, "ofc-proximity-director");
        this.setDaemon(true);
        this.orebfuscator = orebfuscator;
        AdvancedConfig advancedConfig = orebfuscator.getOrebfuscatorConfig().advanced();
        this.workerCount = advancedConfig.proximityThreads();
        this.defaultBucketSize = advancedConfig.proximityDefaultBucketSize();
        this.checkInterval = TimeUnit.MILLISECONDS.toNanos(advancedConfig.proximityThreadCheckInterval());
        this.worker = new ProximityWorker(orebfuscator);
        this.workerThreads = new ProximityWorkerThread[this.workerCount - 1];
        OrebfuscatorStatistics statistics = this.orebfuscator.getStatistics();
        statistics.setProximityWaitTime(() -> (long)this.waitTimer.average());
        statistics.setProximityProcessTime(() -> (long)this.processTimer.average());
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        if (LockSupport.getBlocker(this) == this) {
            LockSupport.unpark(this);
        }
    }

    @Override
    public void start() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.orebfuscator);
        super.start();
        for (int i = 0; i < this.workerCount - 1; ++i) {
            this.workerThreads[i] = new ProximityWorkerThread(this, this.worker);
            this.workerThreads[i].start();
        }
    }

    public void close() {
        this.running = false;
        this.interrupt();
        for (int i = 0; i < this.workerCount - 1; ++i) {
            this.workerThreads[i].interrupt();
        }
        this.phaser.forceTermination();
    }

    boolean isRunning() {
        return this.running && !this.phaser.isTerminated();
    }

    List<Player> nextBucket() throws InterruptedException {
        return this.bucketQueue.take();
    }

    void finishBucketProcessing() {
        this.phaser.arriveAndDeregister();
    }

    @Override
    public void run() {
        while (this.isRunning()) {
            try {
                long processStart = System.nanoTime();
                Collection players = Bukkit.getOnlinePlayers();
                if (players.isEmpty()) {
                    LockSupport.parkNanos(this, 1000000000L);
                    Thread.interrupted();
                    continue;
                }
                int playerCount = players.size();
                int maxBucketSize = Math.max(this.defaultBucketSize, (int)Math.ceil((float)playerCount / (float)this.workerCount));
                int bucketCount = (int)Math.ceil((float)playerCount / (float)maxBucketSize);
                int bucketSize = (int)Math.ceil((float)playerCount / (float)bucketCount);
                if (bucketCount > 1) {
                    this.phaser.bulkRegister(bucketCount - 1);
                }
                ArrayList<Player> localBucket = null;
                Iterator iterator = players.iterator();
                for (int index = 0; index < bucketCount; ++index) {
                    ArrayList<Player> bucket = new ArrayList<Player>();
                    for (int size = 0; size < bucketSize && iterator.hasNext(); ++size) {
                        bucket.add((Player)iterator.next());
                    }
                    if (index == 0) {
                        localBucket = bucket;
                        continue;
                    }
                    this.bucketQueue.offer(bucket);
                }
                this.worker.process(localBucket);
                this.phaser.awaitAdvanceInterruptibly(this.phaser.arrive());
                long processTime = System.nanoTime() - processStart;
                this.processTimer.add(processTime);
                long waitTime = Math.max(0L, this.checkInterval - processTime);
                long waitMillis = TimeUnit.NANOSECONDS.toMillis(waitTime);
                if (waitMillis <= 0L) continue;
                this.waitTimer.add(TimeUnit.MILLISECONDS.toNanos(waitMillis));
                Thread.sleep(waitMillis);
            }
            catch (InterruptedException e) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.phaser.isTerminated() && this.running) {
            OfcLogger.error("Looks like we encountered an invalid state, please report this:", new IllegalStateException("Proximity Phaser terminated!"));
        }
    }
}

