/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator.util;

public class RingTimer {
    private final long[] buffer;
    private int size;
    private int head;
    private Long time;

    public RingTimer(int size) {
        this.buffer = new long[size];
    }

    public double average() {
        if (this.size == 0) {
            return 0.0;
        }
        double sum = 0.0;
        for (int i = 0; i < this.size; ++i) {
            sum += (double)this.buffer[i];
        }
        return sum / (double)this.size;
    }

    public void start() {
        if (this.time == null) {
            this.time = System.nanoTime();
        }
    }

    public void stop() {
        if (this.time != null) {
            this.add(System.nanoTime() - this.time);
            this.time = null;
        }
    }

    public void add(long time) {
        this.buffer[this.head++] = time;
        if (this.head >= this.buffer.length) {
            this.head = 0;
        }
        if (this.size < this.buffer.length) {
            ++this.size;
        }
    }
}

