/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.cache;

import dev.imprex.orebfuscator.config.api.CacheConfig;
import dev.imprex.orebfuscator.reflect.Reflector;
import dev.imprex.orebfuscator.reflect.accessor.MethodAccessor;
import dev.imprex.orebfuscator.reflect.predicate.MethodPredicate;
import dev.imprex.orebfuscator.util.ChunkCacheKey;
import dev.imprex.orebfuscator.util.SimpleCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractRegionFileCache<T> {
    private static MethodAccessor serverGetServer;
    protected final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    protected final Map<Path, T> regionFiles;
    protected final CacheConfig cacheConfig;

    protected static <T> T serverHandle(Object server, Class<T> targetClass) {
        if (serverGetServer == null) {
            serverGetServer = (MethodAccessor)((MethodPredicate)((MethodPredicate)((MethodPredicate)Reflector.of(server.getClass()).method().banStatic()).nameIs("getServer")).returnType().is(targetClass).parameterCount(0)).firstOrThrow();
        }
        return targetClass.cast(serverGetServer.invoke(server, new Object[0]));
    }

    public AbstractRegionFileCache(CacheConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
        this.regionFiles = new SimpleCache<Path, T>(cacheConfig.maximumOpenRegionFiles(), this::remove);
    }

    protected abstract T createRegionFile(Path var1) throws IOException;

    protected abstract void closeRegionFile(T var1) throws IOException;

    protected abstract DataInputStream createInputStream(T var1, ChunkCacheKey var2) throws IOException;

    protected abstract DataOutputStream createOutputStream(T var1, ChunkCacheKey var2) throws IOException;

    public final DataInputStream createInputStream(ChunkCacheKey key) throws IOException {
        T t = this.get(this.cacheConfig.regionFile(key));
        return t != null ? this.createInputStream(t, key) : null;
    }

    public final DataOutputStream createOutputStream(ChunkCacheKey key) throws IOException {
        T t = this.get(this.cacheConfig.regionFile(key));
        return t != null ? this.createOutputStream(t, key) : null;
    }

    private final void remove(Map.Entry<Path, T> entry) {
        try {
            this.closeRegionFile(entry.getValue());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final T get(Path path) throws IOException {
        T t;
        this.lock.readLock().lock();
        try {
            t = this.regionFiles.get(path);
            if (t != null) {
                T t2 = t;
                return t2;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (Files.notExists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        if (this.regionFiles.size() > this.cacheConfig.maximumOpenRegionFiles()) {
            throw new IllegalStateException(String.format("RegionFileCache got bigger than expected (%d > %d)", this.regionFiles.size(), this.cacheConfig.maximumOpenRegionFiles()));
        }
        t = Objects.requireNonNull(this.createRegionFile(path));
        this.lock.writeLock().lock();
        try {
            T previous = this.regionFiles.putIfAbsent(path, t);
            if (previous != null) {
                this.closeRegionFile(t);
                T t3 = previous;
                return t3;
            }
            T t4 = t;
            return t4;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public final void close(Path path) throws IOException {
        this.lock.writeLock().lock();
        try {
            T t = this.regionFiles.remove(path);
            if (t != null) {
                this.closeRegionFile(t);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        this.lock.writeLock().lock();
        try {
            for (T t : this.regionFiles.values()) {
                try {
                    if (t == null) continue;
                    this.closeRegionFile(t);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.regionFiles.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

