/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.chunk;

import dev.imprex.orebfuscator.chunk.ByteBufUtil;
import dev.imprex.orebfuscator.chunk.ChunkFactory;
import dev.imprex.orebfuscator.chunk.ChunkVersionFlags;
import dev.imprex.orebfuscator.chunk.DirectPalette;
import dev.imprex.orebfuscator.chunk.IndirectPalette;
import dev.imprex.orebfuscator.chunk.Palette;
import dev.imprex.orebfuscator.chunk.SimpleVarBitBuffer;
import dev.imprex.orebfuscator.chunk.SingleValuePalette;
import dev.imprex.orebfuscator.chunk.VarBitBuffer;
import dev.imprex.orebfuscator.chunk.ZeroVarBitBuffer;
import dev.imprex.orebfuscator.interop.RegistryAccessor;
import io.netty.buffer.ByteBuf;

public class ChunkSection {
    private final RegistryAccessor registryAccessor;
    private final ChunkVersionFlags versionFlags;
    private int blockCount;
    private int bitsPerBlock = -1;
    private Palette palette;
    private VarBitBuffer data;

    public ChunkSection(ChunkFactory factory) {
        this.registryAccessor = factory.registryAccessor();
        this.versionFlags = factory.versionFlags();
        this.setBitsPerBlock(0, true);
    }

    public RegistryAccessor registryAccessor() {
        return this.registryAccessor;
    }

    private void setBitsPerBlock(int bitsPerBlock, boolean grow) {
        if (this.bitsPerBlock != bitsPerBlock) {
            if (this.versionFlags.hasSingleValuePalette() && bitsPerBlock == 0) {
                this.bitsPerBlock = 0;
                this.palette = new SingleValuePalette(this, 0);
            } else if (!grow && bitsPerBlock == 1) {
                this.bitsPerBlock = bitsPerBlock;
                this.palette = new IndirectPalette(this.bitsPerBlock, this);
            } else if (bitsPerBlock <= 8) {
                this.bitsPerBlock = Math.max(4, bitsPerBlock);
                this.palette = new IndirectPalette(this.bitsPerBlock, this);
            } else {
                this.bitsPerBlock = this.registryAccessor.getMaxBitsPerBlockState();
                this.palette = new DirectPalette();
            }
            this.data = this.bitsPerBlock == 0 ? new ZeroVarBitBuffer(4096) : new SimpleVarBitBuffer(this.bitsPerBlock, 4096);
        }
    }

    int grow(int bitsPerBlock, int blockId) {
        Palette palette = this.palette;
        VarBitBuffer data = this.data;
        this.setBitsPerBlock(bitsPerBlock, true);
        for (int i = 0; i < data.size(); ++i) {
            int preBlockId = palette.valueFor(data.get(i));
            this.data.set(i, this.palette.idFor(preBlockId));
        }
        return this.palette.idFor(blockId);
    }

    static int positionToIndex(int x, int y, int z) {
        return y << 8 | z << 4 | x;
    }

    public void setBlockState(int x, int y, int z, int blockId) {
        this.setBlockState(ChunkSection.positionToIndex(x, y, z), blockId);
    }

    public void setBlockState(int index, int blockId) {
        int prevBlockId = this.getBlockState(index);
        if (!this.registryAccessor.isAir(prevBlockId)) {
            --this.blockCount;
        }
        if (!this.registryAccessor.isAir(blockId)) {
            ++this.blockCount;
        }
        int paletteIndex = this.palette.idFor(blockId);
        this.data.set(index, paletteIndex);
    }

    public int getBlock(int x, int y, int z) {
        return this.getBlockState(ChunkSection.positionToIndex(x, y, z));
    }

    public int getBlockState(int index) {
        return this.palette.valueFor(this.data.get(index));
    }

    public boolean isEmpty() {
        return this.blockCount == 0;
    }

    public void write(ByteBuf buffer) {
        buffer.writeShort(this.blockCount);
        buffer.writeByte(this.bitsPerBlock);
        this.palette.write(buffer);
        long[] data = this.data.toArray();
        if (this.versionFlags.hasLongArrayLengthField()) {
            ByteBufUtil.writeVarInt(buffer, data.length);
        }
        for (long entry : data) {
            buffer.writeLong(entry);
        }
    }

    public int[] read(ByteBuf buffer) {
        int length;
        this.blockCount = buffer.readShort();
        this.setBitsPerBlock(buffer.readUnsignedByte(), false);
        this.palette.read(buffer);
        long[] data = this.data.toArray();
        if (this.versionFlags.hasLongArrayLengthField() && data.length != (length = ByteBufUtil.readVarInt(buffer))) {
            throw new IndexOutOfBoundsException("data.length != VarBitBuffer::size " + length + " " + String.valueOf(this.data));
        }
        for (int i = 0; i < data.length; ++i) {
            data[i] = buffer.readLong();
        }
        int[] directData = new int[4096];
        for (int i = 0; i < directData.length; ++i) {
            directData[i] = this.getBlockState(i);
        }
        return directData;
    }
}

