/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.chunk;

import dev.imprex.orebfuscator.chunk.ByteBufUtil;
import dev.imprex.orebfuscator.chunk.ChunkSection;
import dev.imprex.orebfuscator.chunk.Palette;
import io.netty.buffer.ByteBuf;

public class SingleValuePalette
implements Palette {
    private final ChunkSection chunkSection;
    private int value = -1;

    public SingleValuePalette(ChunkSection chunkSection, int value) {
        this.chunkSection = chunkSection;
        this.value = value;
    }

    @Override
    public int idFor(int value) {
        if (this.value != -1 && value != this.value) {
            return this.chunkSection.grow(1, value);
        }
        this.value = value;
        return 0;
    }

    @Override
    public int valueFor(int id) {
        if (this.value != -1 && id == 0) {
            return this.value;
        }
        throw new IllegalStateException("value isn't initialized");
    }

    @Override
    public void read(ByteBuf buffer) {
        this.value = ByteBufUtil.readVarInt(buffer);
    }

    @Override
    public void write(ByteBuf buffer) {
        if (this.value == -1) {
            throw new IllegalStateException("value isn't initialized");
        }
        ByteBufUtil.writeVarInt(buffer, this.value);
    }
}

