/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.config.components;

import dev.imprex.orebfuscator.config.components.BlockParser;
import dev.imprex.orebfuscator.config.components.ConfigBlockValue;
import dev.imprex.orebfuscator.config.context.ConfigMessage;
import dev.imprex.orebfuscator.config.context.ConfigParsingContext;
import dev.imprex.orebfuscator.config.yaml.ConfigurationSection;
import dev.imprex.orebfuscator.interop.WorldAccessor;
import dev.imprex.orebfuscator.logging.OfcLogger;
import dev.imprex.orebfuscator.util.BlockStateProperties;
import dev.imprex.orebfuscator.util.MathUtil;
import dev.imprex.orebfuscator.util.WeightedRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class WeightedBlockList {
    private final String name;
    private final int minY;
    private final int maxY;
    private final Map<ConfigBlockValue, Integer> blocks = new LinkedHashMap<ConfigBlockValue, Integer>();

    public static WeightedRandom[] create(WorldAccessor world, List<WeightedBlockList> lists) {
        WeightedRandom[] heightMap = new WeightedRandom[world.getHeight()];
        ArrayList last = new ArrayList();
        ArrayList<WeightedBlockList> next = new ArrayList<WeightedBlockList>();
        int count = 0;
        for (int y = world.getMinBuildHeight(); y < world.getMaxBuildHeight(); ++y) {
            for (WeightedBlockList list : lists) {
                if (list.minY > y || list.maxY < y) continue;
                next.add(list);
            }
            int index = y - world.getMinBuildHeight();
            if (index > 0 && last.equals(next)) {
                heightMap[index] = heightMap[index - 1];
            } else {
                WeightedRandom.Builder builder = WeightedRandom.builder();
                for (WeightedBlockList list : next) {
                    for (Map.Entry<ConfigBlockValue, Integer> entry : list.blocks.entrySet()) {
                        Set blockStates = entry.getKey().blocks().stream().map(block -> block.getDefaultBlockState()).collect(Collectors.toSet());
                        double weight = (double)entry.getValue().intValue() / (double)blockStates.size();
                        for (BlockStateProperties state : blockStates) {
                            builder.add(state.getId(), weight);
                        }
                    }
                }
                heightMap[index] = builder.build();
                ++count;
                last.clear();
                last.addAll(next);
            }
            next.clear();
        }
        OfcLogger.debug(String.format("Successfully created %s weighted randoms", count));
        return heightMap;
    }

    public WeightedBlockList(BlockParser.Factory blockParserFactory, ConfigurationSection section, ConfigParsingContext context) {
        this.name = section.getName();
        int minY = MathUtil.clamp(section.getInt("minY", -2032), -2032, 2031);
        int maxY = MathUtil.clamp(section.getInt("maxY", 2031), -2032, 2031);
        this.minY = Math.min(minY, maxY);
        this.maxY = Math.max(minY, maxY);
        ConfigParsingContext blocksContext = context.section("blocks");
        ConfigurationSection blocksSection = section.getSection("blocks");
        if (blocksSection == null) {
            blocksContext.error(ConfigMessage.MISSING_OR_EMPTY, new Object[0]);
            return;
        }
        BlockParser parser = blockParserFactory.includeAir();
        boolean isEmpty = true;
        for (String value : blocksSection.getKeys()) {
            int weight = blocksSection.getInt(value, 1);
            ConfigBlockValue parsed = parser.parse(context, value);
            this.blocks.put(parsed, weight);
            isEmpty &= parsed.blocks().isEmpty();
        }
        if (isEmpty) {
            blocksContext.error(ConfigMessage.MISSING_OR_EMPTY, new Object[0]);
        }
    }

    public void serialize(ConfigurationSection section) {
        section = section.createSection(this.name);
        section.set("minY", this.minY);
        section.set("maxY", this.maxY);
        section = section.createSection("blocks");
        for (Map.Entry<ConfigBlockValue, Integer> entry : this.blocks.entrySet()) {
            section.set(entry.getKey().value(), entry.getValue());
        }
    }

    public String getName() {
        return this.name;
    }

    public Set<ConfigBlockValue> getBlocks() {
        return Collections.unmodifiableSet(this.blocks.keySet());
    }
}

