/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.config.context;

import net.imprex.shaded.org.jetbrains.annotations.Contract;
import net.imprex.shaded.org.jetbrains.annotations.NotNull;

public class ConfigMessage {
    public static final ConfigMessage MISSING_OR_EMPTY = ConfigMessage.fixed("is missing or empty");
    public static final ConfigMessage MISSING_USING_DEFAULTS = ConfigMessage.fixed("is missing, using defaults");
    public static final ConfigMessage DISABLED_ERRORS = ConfigMessage.fixed("got disabled due to errors");
    public static final ConfigMessage VALUE_MIN = ConfigMessage.dynamic("value too low {value(%d) < min(%d)}");
    public static final ConfigMessage VALUE_MIN_MAX = ConfigMessage.dynamic("value out of range {value(%d) not in range[%d, %d]}");
    public static final ConfigMessage FUNCTION_UNKNOWN = ConfigMessage.dynamic("skipping unknown function literal '%s(...)' with argument '%s'");
    public static final ConfigMessage CACHE_INVALID_PATH = ConfigMessage.dynamic("contains malformed path '%s', using default path '%s'");
    public static final ConfigMessage CACHE_CAN_NOT_CREATE = ConfigMessage.dynamic("can't create cache directory '%s'");
    public static final ConfigMessage BLOCK_TAG_UNKNOWN = ConfigMessage.dynamic("skipping unknown block tag '%s'");
    public static final ConfigMessage BLOCK_TAG_EMPTY = ConfigMessage.dynamic("skipping empty block tag '%s'");
    public static final ConfigMessage BLOCK_TAG_AIR_BLOCK = ConfigMessage.dynamic("skipping air block '%s' for block tag '%s'");
    public static final ConfigMessage BLOCK_TAG_AIR_ONLY = ConfigMessage.dynamic("skipping block tag '%s' because it only contains air");
    public static final ConfigMessage BLOCK_UNKNOWN = ConfigMessage.dynamic("skipping unknown block '%s'");
    public static final ConfigMessage BLOCK_AIR = ConfigMessage.dynamic("skipping air block '%s'");
    private final String message;
    private final boolean fixed;

    private static ConfigMessage fixed(@NotNull String message) {
        return new ConfigMessage(message, true);
    }

    private static ConfigMessage dynamic(@NotNull String message) {
        return new ConfigMessage(message, false);
    }

    private ConfigMessage(@NotNull String message, boolean fixed) {
        this.message = message;
        this.fixed = fixed;
    }

    @NotNull
    @Contract(pure=true)
    public String format(Object ... arguments) {
        return this.fixed ? this.message : String.format(this.message, arguments);
    }
}

