/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.config.migrations;

import dev.imprex.orebfuscator.config.migrations.ConfigMigration;
import dev.imprex.orebfuscator.config.yaml.ConfigurationSection;
import java.util.List;
import net.imprex.shaded.org.jetbrains.annotations.NotNull;

class ConfigMigrationV4
implements ConfigMigration {
    ConfigMigrationV4() {
    }

    @Override
    public int sourceVersion() {
        return 4;
    }

    @Override
    @NotNull
    public ConfigurationSection migrate(@NotNull ConfigurationSection root) {
        ConfigMigrationV4.migrateWorlds(root.getSection("obfuscation"));
        ConfigMigrationV4.migrateWorlds(root.getSection("proximity"));
        return root;
    }

    private static void migrateWorlds(ConfigurationSection configContainer) {
        if (configContainer == null) {
            return;
        }
        for (ConfigurationSection config : configContainer.getSubSections()) {
            List<String> worlds = config.getStringList("worlds").stream().map(value -> {
                if (value.startsWith("regex:")) {
                    return String.format("regex(%s)", value.substring(6));
                }
                return value;
            }).toList();
            config.set("worlds", worlds);
        }
    }
}

