/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.reflect.predicate;

import dev.imprex.orebfuscator.reflect.accessor.MemberAccessor;
import dev.imprex.orebfuscator.reflect.predicate.ClassPredicate;
import dev.imprex.orebfuscator.reflect.predicate.RequirementCollector;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.imprex.shaded.org.jetbrains.annotations.Contract;
import net.imprex.shaded.org.jetbrains.annotations.NotNull;
import net.imprex.shaded.org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AbstractMemberPredicate<TThis extends AbstractMemberPredicate<TThis, TAccessor, TMember>, TAccessor extends MemberAccessor<TMember>, TMember extends Member>
implements Predicate<TMember> {
    @NotNull
    private final Function<TThis, Stream<TAccessor>> producer;
    @NotNull
    private final Supplier<String> error;
    private int requiredModifiers;
    private int bannedModifiers;
    private boolean includeSynthetic;
    @Nullable
    private Pattern name;
    @Nullable
    private ClassPredicate declaringClass;

    public AbstractMemberPredicate(@NotNull Function<TThis, Stream<TAccessor>> producer, @NotNull Supplier<String> error) {
        this.producer = producer;
        this.error = error;
    }

    @Override
    public boolean test(@NotNull TMember member) {
        int modifiers = member.getModifiers();
        return !((modifiers & this.requiredModifiers) != this.requiredModifiers || (modifiers & this.bannedModifiers) != 0 || !this.includeSynthetic && member.isSynthetic() || this.name != null && !this.name.matcher(member.getName()).matches() || this.declaringClass != null && !this.declaringClass.test(member.getDeclaringClass()));
    }

    void requirements(@NotNull RequirementCollector collector) {
        if (this.requiredModifiers != 0) {
            collector.collect("requiredModifiers", Modifier.toString(this.requiredModifiers));
        }
        if (this.bannedModifiers != 0) {
            collector.collect("bannedModifiers", Modifier.toString(this.bannedModifiers));
        }
        if (this.includeSynthetic) {
            collector.collect("includeSynthetic");
        }
        if (this.name != null) {
            collector.collect("name", this.name);
        }
        if (this.declaringClass != null) {
            collector.collect("declaringClass", this.declaringClass.requirement());
        }
    }

    @NotNull
    private IllegalArgumentException requirementException() {
        RequirementCollector collector = new RequirementCollector(this.error.get());
        this.requirements(collector);
        return new IllegalArgumentException(collector.get());
    }

    @NotNull
    protected abstract TThis instance();

    @NotNull
    public TThis requireModifier(int modifiers) {
        this.requiredModifiers |= modifiers;
        return this.instance();
    }

    @NotNull
    public TThis requirePublic() {
        return this.requireModifier(1);
    }

    @NotNull
    public TThis requireProtected() {
        return this.requireModifier(4);
    }

    @NotNull
    public TThis requirePrivate() {
        return this.requireModifier(2);
    }

    @NotNull
    public TThis requireStatic() {
        return this.requireModifier(8);
    }

    @NotNull
    public TThis requireFinal() {
        return this.requireModifier(16);
    }

    @NotNull
    public TThis banModifier(int modifiers) {
        this.bannedModifiers |= modifiers;
        return this.instance();
    }

    @NotNull
    public TThis banPublic() {
        return this.banModifier(1);
    }

    @NotNull
    public TThis banProtected() {
        return this.banModifier(4);
    }

    @NotNull
    public TThis banPrivate() {
        return this.banModifier(2);
    }

    @NotNull
    public TThis banStatic() {
        return this.banModifier(8);
    }

    @NotNull
    public TThis banFinal() {
        return this.banModifier(16);
    }

    @NotNull
    public TThis includeSynthetic() {
        this.includeSynthetic = true;
        return this.instance();
    }

    @NotNull
    public TThis nameRegex(@NotNull Pattern pattern) {
        this.name = Objects.requireNonNull(pattern);
        return this.instance();
    }

    @NotNull
    public TThis nameIs(@NotNull String name) {
        String pattern = Pattern.quote(Objects.requireNonNull(name));
        return this.nameRegex(Pattern.compile(pattern));
    }

    @NotNull
    public TThis nameIsIgnoreCase(@NotNull String name) {
        String pattern = Pattern.quote(Objects.requireNonNull(name));
        return this.nameRegex(Pattern.compile(pattern, 2));
    }

    @NotNull
    public TThis declaringClass(@NotNull ClassPredicate matcher) {
        this.declaringClass = Objects.requireNonNull(matcher);
        return this.instance();
    }

    @NotNull
    public ClassPredicate.Builder<TThis> declaringClass() {
        return new ClassPredicate.Builder<AbstractMemberPredicate>(this::declaringClass);
    }

    @Contract(pure=true)
    @NotNull
    public Stream<TAccessor> stream() {
        return this.producer.apply(this.instance());
    }

    @Contract(pure=true)
    @Nullable
    public TAccessor get(int index) {
        return (TAccessor)((MemberAccessor)this.stream().skip(index).findFirst().orElse(null));
    }

    @Contract(pure=true)
    @NotNull
    public TAccessor getOrThrow(int index) {
        return (TAccessor)((MemberAccessor)this.stream().skip(index).findFirst().orElseThrow(this::requirementException));
    }

    @Contract(pure=true)
    @Nullable
    public TAccessor first() {
        return (TAccessor)((MemberAccessor)this.stream().findFirst().orElse(null));
    }

    @Contract(pure=true)
    @NotNull
    public TAccessor firstOrThrow() {
        return (TAccessor)((MemberAccessor)this.stream().findFirst().orElseThrow(this::requirementException));
    }

    @Contract(pure=true)
    @Nullable
    public TAccessor find(@NotNull Predicate<TMember> predicate) {
        return (TAccessor)((MemberAccessor)this.stream().filter(accessor -> predicate.test(accessor.member())).findFirst().orElse(null));
    }

    @Contract(pure=true)
    @NotNull
    public TAccessor findOrThrow(@NotNull Predicate<TMember> predicate) {
        return (TAccessor)this.stream().filter(accessor -> predicate.test(accessor.member())).findFirst().orElseThrow(this::requirementException);
    }
}

