/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.util;

import dev.imprex.orebfuscator.util.ChunkCacheKey;

public enum ChunkDirection {
    NORTH(1, 0),
    EAST(0, 1),
    SOUTH(-1, 0),
    WEST(0, -1);

    private final int offsetX;
    private final int offsetZ;

    private ChunkDirection(int offsetX, int offsetZ) {
        this.offsetX = offsetX;
        this.offsetZ = offsetZ;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetZ() {
        return this.offsetZ;
    }

    public static ChunkDirection fromPosition(ChunkCacheKey key, int targetX, int targetZ) {
        int offsetX = (targetX >> 4) - key.x();
        int offsetZ = (targetZ >> 4) - key.z();
        if (offsetX == 1 && offsetZ == 0) {
            return NORTH;
        }
        if (offsetX == 0 && offsetZ == 1) {
            return EAST;
        }
        if (offsetX == -1 && offsetZ == 0) {
            return SOUTH;
        }
        if (offsetX == 0 && offsetZ == -1) {
            return WEST;
        }
        throw new IllegalArgumentException(String.format("invalid offset (origin: %s, x: %d, z: %d)", key, targetX, targetZ));
    }
}

