/*
 * Decompiled with CFR 0.152.
 */
package dev.imprex.orebfuscator.util;

import java.util.ArrayDeque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.random.RandomGenerator;
import net.imprex.shaded.org.jetbrains.annotations.NotNull;

public final class WeightedRandom {
    private final int n;
    private final double totalWeight;
    private final boolean allWeightsEqual;
    private final int[] values;
    private final double[] probabilities;
    private final int[] alias;

    public static Builder builder() {
        return new Builder();
    }

    private WeightedRandom(@NotNull Builder builder) {
        double minWeight = Double.POSITIVE_INFINITY;
        double maxWeight = Double.NEGATIVE_INFINITY;
        double totalWeight = 0.0;
        this.n = builder.entries.size();
        this.values = new int[this.n];
        this.probabilities = new double[this.n];
        this.alias = new int[this.n];
        double[] scaled = new double[this.n];
        ArrayDeque<Integer> small = new ArrayDeque<Integer>();
        ArrayDeque<Integer> large = new ArrayDeque<Integer>();
        int index = 0;
        for (Map.Entry<Integer, Double> entry : builder.entries.entrySet()) {
            this.values[index] = entry.getKey();
            double weight = entry.getValue();
            minWeight = Math.min(minWeight, weight);
            maxWeight = Math.max(maxWeight, weight);
            totalWeight += weight;
            scaled[index++] = weight * (double)this.n;
        }
        this.totalWeight = totalWeight;
        double span = maxWeight - minWeight;
        if (span <= Math.ulp(maxWeight) * 4.0 || span <= 1.0E-12 * Math.max(1.0, maxWeight)) {
            this.allWeightsEqual = true;
            return;
        }
        this.allWeightsEqual = false;
        for (int i = 0; i < this.n; ++i) {
            if (scaled[i] < totalWeight) {
                small.addLast(i);
                continue;
            }
            large.addLast(i);
        }
        while (!small.isEmpty() && !large.isEmpty()) {
            int l = (Integer)small.removeLast();
            int g = (Integer)large.removeLast();
            this.probabilities[l] = scaled[l];
            this.alias[l] = g;
            scaled[g] = scaled[g] + scaled[l] - totalWeight;
            if (scaled[g] < totalWeight) {
                small.addLast(g);
                continue;
            }
            large.addLast(g);
        }
        while (!large.isEmpty()) {
            this.probabilities[((Integer)large.removeLast()).intValue()] = totalWeight;
        }
        while (!small.isEmpty()) {
            this.probabilities[((Integer)small.removeLast()).intValue()] = totalWeight;
        }
    }

    public int next() {
        return this.next(ThreadLocalRandom.current());
    }

    public int next(@NotNull RandomGenerator random) {
        Objects.requireNonNull(random);
        int i = random.nextInt(this.n);
        if (this.allWeightsEqual) {
            return this.values[i];
        }
        int pick = random.nextDouble(this.totalWeight) < this.probabilities[i] ? i : this.alias[i];
        return this.values[pick];
    }

    public static class Builder {
        private final Map<Integer, Double> entries = new LinkedHashMap<Integer, Double>();

        private Builder() {
        }

        public Builder add(int value, double weight) {
            if (weight <= 0.0 || !Double.isFinite(weight)) {
                throw new IllegalArgumentException("Weight has to be greater zero and finite!");
            }
            this.entries.merge(value, weight, (a, b) -> a + b);
            return this;
        }

        public WeightedRandom build() {
            if (this.entries.isEmpty()) {
                throw new IllegalStateException("No entries added!");
            }
            return new WeightedRandom(this);
        }
    }
}

