/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator;

import java.util.Collection;
import java.util.Iterator;
import net.imprex.orebfuscator.Orebfuscator;
import net.imprex.orebfuscator.OrebfuscatorCompatibility;
import net.imprex.orebfuscator.api.OrebfuscatorService;
import net.imprex.orebfuscator.obfuscation.ObfuscationSystem;
import org.bukkit.World;
import org.bukkit.block.Block;

public final class DefaultOrebfuscatorService
implements OrebfuscatorService {
    private final ObfuscationSystem obfuscationSystem;

    public DefaultOrebfuscatorService(Orebfuscator orebfuscator) {
        this.obfuscationSystem = orebfuscator.getObfuscationSystem();
    }

    @Override
    public final void deobfuscate(Collection<? extends Block> blocks) {
        if (!OrebfuscatorCompatibility.isGameThread()) {
            throw new IllegalStateException("Asynchronous deobfuscation! " + String.valueOf(Thread.currentThread()));
        }
        if (blocks == null || blocks.isEmpty()) {
            throw new IllegalArgumentException("block list is null or empty");
        }
        Iterator<? extends Block> blockIterator = blocks.iterator();
        World world = blockIterator.next().getWorld();
        while (blockIterator.hasNext()) {
            if (blockIterator.next().getWorld() == world) continue;
            throw new IllegalArgumentException("block list is located in more than one world");
        }
        this.obfuscationSystem.deobfuscate(blocks);
    }
}

