/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator;

import com.google.gson.annotations.SerializedName;
import dev.imprex.orebfuscator.config.api.GeneralConfig;
import dev.imprex.orebfuscator.logging.LogLevel;
import dev.imprex.orebfuscator.logging.OfcLogger;
import dev.imprex.orebfuscator.util.Version;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.imprex.orebfuscator.Orebfuscator;
import net.imprex.orebfuscator.OrebfuscatorCompatibility;
import net.imprex.orebfuscator.util.AbstractHttpService;
import net.imprex.orebfuscator.util.ConsoleUtil;
import net.imprex.orebfuscator.util.MinecraftVersion;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.entity.Player;

public class UpdateSystem
extends AbstractHttpService {
    private static final Pattern DEV_VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(?:-b(?<build>\\d+))?");
    private static final String API_URI = "https://api.modrinth.com/v2/project/orebfuscator/version?loaders=%s&game_versions=%s";
    private static final String DOWNLOAD_URI = "https://modrinth.com/plugin/orebfuscator/version/%s";
    private static final Duration CACHE_DURATION = Duration.ofMinutes(10L);
    private final Orebfuscator orebfuscator;
    private final GeneralConfig generalConfig;
    private final AtomicReference<Instant> validUntil = new AtomicReference();
    private final AtomicReference<CompletableFuture<Optional<ModrinthVersion>>> latestVersion = new AtomicReference();

    private static boolean isDevVersion(String version) {
        Matcher matcher = DEV_VERSION_PATTERN.matcher(version);
        return matcher.find() && matcher.group("build") != null;
    }

    public UpdateSystem(Orebfuscator orebfuscator) {
        super(orebfuscator);
        this.orebfuscator = orebfuscator;
        this.generalConfig = orebfuscator.getOrebfuscatorConfig().general();
        this.checkForUpdates();
    }

    private CompletableFuture<Optional<ModrinthVersion>> requestLatestVersion() {
        String installedVersion = this.orebfuscator.getDescription().getVersion();
        if (!this.generalConfig.checkForUpdates() || UpdateSystem.isDevVersion(installedVersion)) {
            OfcLogger.debug("UpdateSystem - Update check disabled or dev version detected; skipping");
            return CompletableFuture.completedFuture(Optional.empty());
        }
        String uri = String.format(API_URI, "bukkit", MinecraftVersion.current());
        return ((CompletableFuture)HTTP.sendAsync(this.request(uri).build(), UpdateSystem.optionalJson(ModrinthVersion[].class)).thenApply(response -> ((Optional)response.body()).flatMap(body -> {
            Version version = Version.parse(installedVersion);
            Optional<ModrinthVersion> latestVersion = Arrays.stream(body).filter(e -> Objects.equals(e.versionType, "release")).filter(e -> Objects.equals(e.status, "listed")).sorted(Comparator.reverseOrder()).findFirst();
            latestVersion.ifPresentOrElse(v -> OfcLogger.debug("UpdateSystem - Fetched latest version " + String.valueOf(v.version)), () -> OfcLogger.debug("UpdateSystem - Couldn't fetch latest version"));
            return latestVersion.map(v -> version.isBelow(v.version) ? v : null);
        }))).exceptionally(throwable -> {
            OfcLogger.log(LogLevel.WARN, "UpdateSystem - Unable to fetch latest version", throwable);
            return Optional.empty();
        });
    }

    private CompletableFuture<Optional<ModrinthVersion>> getLatestVersion() {
        CompletableFuture<Optional<ModrinthVersion>> existingFuture;
        Instant validUntil = this.validUntil.get();
        if (validUntil != null && validUntil.compareTo(Instant.now()) < 0 && this.validUntil.compareAndSet(validUntil, null)) {
            OfcLogger.debug("UpdateSystem - Cleared latest cached version");
            this.latestVersion.set(null);
        }
        if ((existingFuture = this.latestVersion.get()) != null) {
            return existingFuture;
        }
        CompletableFuture<Optional<ModrinthVersion>> newFuture = new CompletableFuture<Optional<ModrinthVersion>>();
        if (this.latestVersion.compareAndSet(null, newFuture)) {
            OfcLogger.debug("UpdateSystem - Starting to check for updates");
            this.requestLatestVersion().thenAccept(version -> {
                this.validUntil.set(Instant.now().plus(CACHE_DURATION));
                newFuture.complete((Optional<ModrinthVersion>)version);
            });
            return newFuture;
        }
        return this.latestVersion.get();
    }

    private void ifNewerVersionAvailable(Consumer<ModrinthVersion> consumer) {
        this.getLatestVersion().thenAccept(o -> o.ifPresent(consumer));
    }

    private void checkForUpdates() {
        this.ifNewerVersionAvailable(version -> {
            String downloadUri = String.format(DOWNLOAD_URI, version.version);
            ConsoleUtil.printBox(LogLevel.WARN, "UPDATE AVAILABLE", "", downloadUri);
        });
    }

    public void checkForUpdates(Player player) {
        this.ifNewerVersionAvailable(version -> {
            String downloadUri = String.format(DOWNLOAD_URI, version.version);
            BaseComponent[] components = new ComponentBuilder("[\u00a7bOrebfuscator\u00a7f]\u00a77 A new release is available ").append("\u00a7f\u00a7l[CLICK HERE]").event(new ClickEvent(ClickEvent.Action.OPEN_URL, downloadUri)).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(new ComponentBuilder("\u00a77Click here to see the latest release").create())})).create();
            OrebfuscatorCompatibility.runForPlayer(player, () -> player.spigot().sendMessage(components));
        });
    }

    public static class ModrinthVersion
    implements Comparable<ModrinthVersion> {
        private static final Comparator<ModrinthVersion> COMPARATOR = Comparator.comparing(e -> e.version, Comparator.nullsLast(Version::compareTo));
        @SerializedName(value="version_number")
        public Version version;
        @SerializedName(value="game_versions")
        public List<Version> gameVersions;
        @SerializedName(value="version_type")
        public String versionType;
        @SerializedName(value="loaders")
        public List<String> loaders;
        @SerializedName(value="status")
        public String status;

        @Override
        public int compareTo(ModrinthVersion other) {
            return COMPARATOR.compare(this, other);
        }
    }
}

