/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator.cache;

import dev.imprex.orebfuscator.util.BlockPos;
import dev.imprex.orebfuscator.util.ChunkCacheKey;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.imprex.orebfuscator.obfuscation.ObfuscationRequest;
import net.imprex.orebfuscator.obfuscation.ObfuscationResult;
import net.imprex.shaded.net.jpountz.lz4.LZ4BlockOutputStream;

public class CacheChunkEntry {
    private final ChunkCacheKey key;
    private final byte[] compressedData;

    public static CacheChunkEntry create(ObfuscationResult result) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (LZ4BlockOutputStream lz4BlockOutputStream = new LZ4BlockOutputStream(byteArrayOutputStream);
             DataOutputStream dataOutputStream = new DataOutputStream(lz4BlockOutputStream);){
            byteArrayOutputStream.write(result.getHash());
            byte[] data = result.getData();
            dataOutputStream.writeInt(data.length);
            dataOutputStream.write(data, 0, data.length);
            List<BlockPos> proximityBlocks = result.getProximityBlocks();
            dataOutputStream.writeInt(proximityBlocks.size());
            for (BlockPos blockPosition : proximityBlocks) {
                dataOutputStream.writeInt(blockPosition.toSectionPos());
            }
            Set<BlockPos> removedEntities = result.getBlockEntities();
            dataOutputStream.writeInt(removedEntities.size());
            for (BlockPos blockPosition : removedEntities) {
                dataOutputStream.writeInt(blockPosition.toSectionPos());
            }
        }
        catch (Exception e) {
            new IOException("Unable to compress chunk: " + String.valueOf(result.getCacheKey()), e).printStackTrace();
            return null;
        }
        return new CacheChunkEntry(result.getCacheKey(), byteArrayOutputStream.toByteArray());
    }

    public CacheChunkEntry(ChunkCacheKey key, byte[] data) {
        this.key = key;
        this.compressedData = data;
    }

    public byte[] compressedData() {
        return this.compressedData;
    }

    public int estimatedSize() {
        return 128 + this.compressedData.length;
    }

    public boolean isValid(ObfuscationRequest request) {
        try {
            return request != null && Arrays.equals(this.compressedData, 0, ObfuscationRequest.HASH_LENGTH, request.getChunkHash(), 0, ObfuscationRequest.HASH_LENGTH);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to validate", e);
        }
    }

    /*
     * Exception decompiling
     */
    public Optional<ObfuscationResult> toResult() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

