/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator.cache;

import dev.imprex.orebfuscator.cache.AbstractRegionFileCache;
import dev.imprex.orebfuscator.config.api.CacheConfig;
import dev.imprex.orebfuscator.logging.OfcLogger;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import net.imprex.orebfuscator.Orebfuscator;

public class CacheFileCleanupTask
implements Runnable {
    private final CacheConfig cacheConfig;
    private final AbstractRegionFileCache<?> regionFileCache;
    private int deleteCount = 0;

    public CacheFileCleanupTask(Orebfuscator orebfuscator, AbstractRegionFileCache<?> regionFileCache) {
        this.cacheConfig = orebfuscator.getOrebfuscatorConfig().cache();
        this.regionFileCache = regionFileCache;
    }

    @Override
    public void run() {
        if (Files.notExists(this.cacheConfig.baseDirectory(), new LinkOption[0])) {
            OfcLogger.debug("Skipping CacheFileCleanupTask as the cache directory doesn't exist.");
            return;
        }
        final long deleteAfterMillis = this.cacheConfig.deleteRegionFilesAfterAccess();
        this.deleteCount = 0;
        try {
            Files.walkFileTree(this.cacheConfig.baseDirectory(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attributes) throws IOException {
                    if (System.currentTimeMillis() - attributes.lastAccessTime().toMillis() > deleteAfterMillis) {
                        CacheFileCleanupTask.this.regionFileCache.close(path);
                        Files.delete(path);
                        ++CacheFileCleanupTask.this.deleteCount;
                        OfcLogger.debug("deleted cache file: " + String.valueOf(path));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.deleteCount > 0) {
            OfcLogger.info(String.format("CacheFileCleanupTask successfully deleted %d cache file(s)", this.deleteCount));
        }
    }
}

