/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator.cache;

import dev.imprex.orebfuscator.cache.AbstractRegionFileCache;
import dev.imprex.orebfuscator.util.ChunkCacheKey;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.imprex.orebfuscator.cache.CacheChunkEntry;
import net.imprex.shaded.org.jetbrains.annotations.NotNull;
import net.imprex.shaded.org.jetbrains.annotations.Nullable;

public class ChunkSerializer {
    private static final int CACHE_VERSION = 2;
    private final AbstractRegionFileCache<?> regionFileCache;

    public ChunkSerializer(AbstractRegionFileCache<?> regionFileCache) {
        this.regionFileCache = regionFileCache;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public CacheChunkEntry read(@NotNull ChunkCacheKey key) throws IOException {
        try (DataInputStream dataInputStream = this.regionFileCache.createInputStream(key);){
            if (dataInputStream == null) return null;
            if (dataInputStream.readInt() != 2 || !dataInputStream.readBoolean()) {
                CacheChunkEntry cacheChunkEntry = null;
                return cacheChunkEntry;
            }
            byte[] compressedData = new byte[dataInputStream.readInt()];
            dataInputStream.readFully(compressedData);
            CacheChunkEntry cacheChunkEntry = new CacheChunkEntry(key, compressedData);
            return cacheChunkEntry;
        }
        catch (IOException e) {
            throw new IOException("Unable to read chunk: " + String.valueOf(key), e);
        }
    }

    public void write(@NotNull ChunkCacheKey key, @Nullable CacheChunkEntry value) throws IOException {
        try (DataOutputStream dataOutputStream = this.regionFileCache.createOutputStream(key);){
            dataOutputStream.writeInt(2);
            if (value != null) {
                dataOutputStream.writeBoolean(true);
                byte[] compressedData = value.compressedData();
                dataOutputStream.writeInt(compressedData.length);
                dataOutputStream.write(compressedData);
            } else {
                dataOutputStream.writeBoolean(false);
            }
        }
        catch (IOException e) {
            throw new IOException("Unable to write chunk: " + String.valueOf(key), e);
        }
    }
}

