/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import dev.imprex.orebfuscator.cache.AbstractRegionFileCache;
import dev.imprex.orebfuscator.config.api.CacheConfig;
import dev.imprex.orebfuscator.util.ChunkCacheKey;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.imprex.orebfuscator.Orebfuscator;
import net.imprex.orebfuscator.OrebfuscatorCompatibility;
import net.imprex.orebfuscator.OrebfuscatorNms;
import net.imprex.orebfuscator.OrebfuscatorStatistics;
import net.imprex.orebfuscator.cache.AsyncChunkSerializer;
import net.imprex.orebfuscator.cache.CacheChunkEntry;
import net.imprex.orebfuscator.cache.CacheFileCleanupTask;
import net.imprex.orebfuscator.obfuscation.ObfuscationRequest;
import net.imprex.orebfuscator.obfuscation.ObfuscationResult;
import net.imprex.shaded.org.jetbrains.annotations.NotNull;

public class ObfuscationCache {
    private final CacheConfig cacheConfig;
    private final OrebfuscatorStatistics statistics;
    private final AbstractRegionFileCache<?> regionFileCache;
    private final Cache<ChunkCacheKey, CacheChunkEntry> cache;
    private final AsyncChunkSerializer serializer;

    public ObfuscationCache(Orebfuscator orebfuscator) {
        this.cacheConfig = orebfuscator.getOrebfuscatorConfig().cache();
        this.statistics = orebfuscator.getStatistics();
        this.cache = CacheBuilder.newBuilder().maximumSize((long)this.cacheConfig.maximumSize()).expireAfterAccess(this.cacheConfig.expireAfterAccess(), TimeUnit.MILLISECONDS).removalListener(this::onRemoval).build();
        this.statistics.setMemoryCacheSizeSupplier(() -> this.cache.size());
        this.regionFileCache = OrebfuscatorNms.createRegionFileCache(orebfuscator.getOrebfuscatorConfig());
        this.serializer = this.cacheConfig.enableDiskCache() ? new AsyncChunkSerializer(orebfuscator, this.regionFileCache) : null;
        if (this.cacheConfig.enabled() && this.cacheConfig.deleteRegionFilesAfterAccess() > 0L) {
            OrebfuscatorCompatibility.runAsyncAtFixedRate(new CacheFileCleanupTask(orebfuscator, this.regionFileCache), 0L, 72000L);
        }
    }

    private void onRemoval(@NotNull RemovalNotification<ChunkCacheKey, CacheChunkEntry> notification) {
        this.statistics.onCacheSizeChange(-((CacheChunkEntry)notification.getValue()).estimatedSize());
        if (this.cacheConfig.enableDiskCache() && notification.wasEvicted() && !OrebfuscatorCompatibility.isGameThread()) {
            this.serializer.write((ChunkCacheKey)notification.getKey(), (CacheChunkEntry)notification.getValue());
        }
    }

    private void requestObfuscation(@NotNull ObfuscationRequest request) {
        request.submitForObfuscation().thenAccept(chunk -> {
            CacheChunkEntry compressedChunk = CacheChunkEntry.create(chunk);
            if (compressedChunk != null) {
                this.cache.put((Object)request.getCacheKey(), (Object)compressedChunk);
                this.statistics.onCacheSizeChange(compressedChunk.estimatedSize());
            }
        });
    }

    @NotNull
    public CompletableFuture<ObfuscationResult> get(@NotNull ObfuscationRequest request) {
        ChunkCacheKey key = request.getCacheKey();
        CacheChunkEntry cacheChunk = (CacheChunkEntry)this.cache.getIfPresent((Object)key);
        if (cacheChunk != null && cacheChunk.isValid(request)) {
            this.statistics.onCacheHitMemory();
            cacheChunk.toResult().ifPresentOrElse(request::complete, () -> this.requestObfuscation(request));
        } else if (cacheChunk == null && this.cacheConfig.enableDiskCache()) {
            this.serializer.read(key).whenComplete((diskChunk, throwable) -> {
                if (diskChunk != null && diskChunk.isValid(request)) {
                    this.statistics.onCacheHitDisk();
                    this.cache.put((Object)key, diskChunk);
                    this.statistics.onCacheSizeChange(diskChunk.estimatedSize());
                    diskChunk.toResult().ifPresentOrElse(request::complete, () -> this.requestObfuscation(request));
                } else {
                    this.statistics.onCacheMiss();
                    this.requestObfuscation(request);
                }
                if (throwable != null) {
                    throwable.printStackTrace();
                }
            });
        } else {
            this.statistics.onCacheMiss();
            this.requestObfuscation(request);
        }
        return request.getFuture();
    }

    public void invalidate(ChunkCacheKey key) {
        this.cache.invalidate((Object)key);
    }

    public void close() {
        if (this.serializer != null) {
            this.cache.asMap().entrySet().removeIf(entry -> {
                this.serializer.write((ChunkCacheKey)entry.getKey(), (CacheChunkEntry)entry.getValue());
                return true;
            });
            this.serializer.close();
        }
        this.regionFileCache.clear();
    }
}

