/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator.nms.v1_20_R4_mojang;

import dev.imprex.orebfuscator.cache.AbstractRegionFileCache;
import dev.imprex.orebfuscator.config.api.CacheConfig;
import dev.imprex.orebfuscator.util.ChunkCacheKey;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionFileVersion;
import org.bukkit.Bukkit;

public class RegionFileCache
extends AbstractRegionFileCache<RegionFile> {
    RegionFileCache(CacheConfig cacheConfig) {
        super(cacheConfig);
    }

    @Override
    protected RegionFile createRegionFile(Path path) throws IOException {
        boolean isSyncChunkWrites = RegionFileCache.serverHandle(Bukkit.getServer(), DedicatedServer.class).forceSynchronousWrites();
        return new RegionFile(null, path, path.getParent(), RegionFileVersion.VERSION_NONE, isSyncChunkWrites);
    }

    @Override
    protected void closeRegionFile(RegionFile t) throws IOException {
        t.close();
    }

    @Override
    protected DataInputStream createInputStream(RegionFile t, ChunkCacheKey key) throws IOException {
        return t.getChunkDataInputStream(new ChunkPos(key.x(), key.z()));
    }

    @Override
    protected DataOutputStream createOutputStream(RegionFile t, ChunkCacheKey key) throws IOException {
        return t.getChunkDataOutputStream(new ChunkPos(key.x(), key.z()));
    }
}

