/*
 * Decompiled with CFR 0.152.
 */
package net.imprex.orebfuscator.util;

import dev.imprex.orebfuscator.logging.LogLevel;
import dev.imprex.orebfuscator.logging.OfcLogger;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.ChatColor;

public final class ConsoleUtil {
    private static final int BOX_PADDING = 3;
    private static final int BOX_PREFERRED_WIDTH = 48;

    private ConsoleUtil() {
    }

    public static String replaceAnsiColorWithChatColor(String value) {
        value = value.replaceAll("\u001b\\[m", ChatColor.RESET.toString());
        value = value.replaceAll("\u001b\\[31;1m", ChatColor.RED.toString());
        value = value.replaceAll("\u001b\\[33;1m", ChatColor.YELLOW.toString());
        return value;
    }

    public static void printBox(LogLevel level, String ... lines) {
        for (String line : ConsoleUtil.createBox(lines)) {
            OfcLogger.log(level, line);
        }
    }

    public static Iterable<String> createBox(String ... lines) {
        ArrayList<String> wrappedLines = new ArrayList<String>();
        for (String line : lines) {
            line = line.trim();
            while (line.length() > 48) {
                int splitLength = 0;
                for (int i = 0; i < line.length(); ++i) {
                    if (!Character.isWhitespace(line.charAt(i))) continue;
                    if (i > 48) break;
                    splitLength = i;
                }
                if (splitLength == 0) break;
                wrappedLines.add(line.substring(0, splitLength));
                line = line.substring(splitLength, line.length()).trim();
            }
            wrappedLines.add(line);
        }
        int width = 0;
        for (String line : wrappedLines) {
            width = Math.max(width, line.length());
        }
        int totalWidth = width + 6;
        String bottomTopLine = ConsoleUtil.repeat('-', totalWidth);
        String topLine = String.format("+%s+", bottomTopLine);
        String bottomLine = String.format("+%s+", bottomTopLine);
        ArrayList<String> box = new ArrayList<String>(wrappedLines.size() + 2);
        box.add(topLine);
        for (String line : wrappedLines) {
            String leftPadding;
            String rightPadding;
            int space = totalWidth - line.length();
            if (space % 2 == 0) {
                leftPadding = rightPadding = ConsoleUtil.repeat(' ', space / 2);
            } else {
                leftPadding = ConsoleUtil.repeat(' ', space / 2 + 1);
                rightPadding = ConsoleUtil.repeat(' ', space / 2);
            }
            box.add(String.format("|%s%s%s|", leftPadding, line, rightPadding));
        }
        box.add(bottomLine);
        return box;
    }

    private static String repeat(char character, int length) {
        char[] string = new char[length];
        Arrays.fill(string, character);
        return new String(string);
    }
}

