/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.color.advanced.mode;

import lombok.Generated;
import net.lopymine.ip.color.advanced.mode.IAdvancedParticleColorTypeMode;
import net.lopymine.ip.element.base.TickElement;
import net.lopymine.ip.utils.ArgbUtils2;
import net.minecraft.class_5819;

public class AdvancedParticleColorTypeGradientLoopMode
extends TickElement
implements IAdvancedParticleColorTypeMode {
    protected final int time;

    public AdvancedParticleColorTypeGradientLoopMode(int time) {
        this.time = time;
    }

    @Override
    public IAdvancedParticleColorTypeMode copy() {
        return new AdvancedParticleColorTypeGradientLoopMode(this.time);
    }

    @Override
    public int tickResolve(Integer[] compiledColors, class_5819 random) {
        if (compiledColors.length == 1) {
            return compiledColors[0];
        }
        this.tick();
        float progress = (float)(this.ticks % this.time) / (float)this.time;
        int totalSegments = compiledColors.length;
        float segmentProgress = progress * (float)totalSegments;
        int segmentIndex = (int)segmentProgress;
        float currentSegmentProgress = segmentProgress - (float)segmentIndex;
        int secondColorIndex = segmentIndex + 1;
        if (secondColorIndex >= totalSegments) {
            secondColorIndex = 0;
        }
        int first = compiledColors[segmentIndex];
        int second = compiledColors[secondColorIndex];
        return ArgbUtils2.lerp(currentSegmentProgress, first, second);
    }

    @Override
    public String asString() {
        return "gradient_loop";
    }

    @Generated
    public int getTime() {
        return this.time;
    }
}

