/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.config.particle;

import com.google.common.base.CaseFormat;
import com.mojang.serialization.Codec;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import net.lopymine.ip.client.InventoryParticlesClient;
import net.lopymine.ip.debug.HideInDebugRender;
import net.lopymine.ip.utils.Easing;
import net.minecraft.class_3532;

public class DynamicParticleSizeInterpolation {
    private static final Map<String, Function<Double, Double>> REGISTERED_INTERPOLATIONS = new HashMap<String, Function<Double, Double>>();
    public static final DynamicParticleSizeInterpolation NO_INTERPOLATION = new DynamicParticleSizeInterpolation("shouldn't be registered", f -> 1.0);
    public static final Function<Double, Double> LINEAR_FUNCTION = f -> f;
    public static final DynamicParticleSizeInterpolation LINEAR_INTERPOLATION = new DynamicParticleSizeInterpolation("linear", LINEAR_FUNCTION);
    public static final Codec<DynamicParticleSizeInterpolation> CODEC;
    private String id;
    @HideInDebugRender
    private Function<Double, Double> function;

    private static void register(String id, Function<Double, Double> function) {
        REGISTERED_INTERPOLATIONS.put(id, function);
    }

    public double getInterpolated(double first, double second, double progress) {
        return class_3532.method_16436((double)this.function.apply(progress), (double)first, (double)second);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Function<Double, Double> getFunction() {
        return this.function;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setFunction(Function<Double, Double> function) {
        this.function = function;
    }

    @Generated
    public DynamicParticleSizeInterpolation(String id, Function<Double, Double> function) {
        this.id = id;
        this.function = function;
    }

    static {
        DynamicParticleSizeInterpolation.register(DynamicParticleSizeInterpolation.LINEAR_INTERPOLATION.id, DynamicParticleSizeInterpolation.LINEAR_INTERPOLATION.function);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        for (Method method : Easing.class.getDeclaredMethods()) {
            if (method.getReturnType() != Double.TYPE || method.getParameterCount() != 1 || method.getParameters()[0].getType() != Double.TYPE) continue;
            String name = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, method.getName());
            try {
                MethodHandle methodHandle = lookup.unreflect(method);
                CallSite site = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(Function.class), MethodType.methodType(Object.class, Object.class), methodHandle, MethodType.methodType(Double.class, Double.class));
                Function function = site.getTarget().invokeExact();
                DynamicParticleSizeInterpolation.register(name, function);
            }
            catch (Throwable e) {
                InventoryParticlesClient.LOGGER.error("Failed to bind easing method \"{}\" for particle size interpolation!", (Object)name, (Object)e);
            }
        }
        CODEC = Codec.STRING.xmap(s -> {
            Function<Double, Double> function = REGISTERED_INTERPOLATIONS.get(s);
            if (function == null) {
                InventoryParticlesClient.LOGGER.error("Failed to find interpolation method with name \"{}\"!", s);
                return NO_INTERPOLATION;
            }
            return new DynamicParticleSizeInterpolation((String)s, function);
        }, i -> i.id);
    }
}

