/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.color;

import com.mojang.serialization.Codec;
import java.util.Map;
import net.lopymine.ip.color.CustomParticleColorType;
import net.lopymine.ip.color.NbtListParticleColorType;
import net.lopymine.ip.color.NbtParticleColorType;
import net.lopymine.ip.color.StandardParticleColorType;
import net.lopymine.ip.debug.HideInDebugRender;
import net.lopymine.ip.debug.IDebugRenderable;
import net.minecraft.class_1799;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public interface IParticleColorType
extends IDebugRenderable {
    @HideInDebugRender
    public static final Map<String, ParticleColorTypeFactory> FACTORIES = Map.of("nbt", s -> new NbtParticleColorType(), "nbt_list", s -> new NbtListParticleColorType());
    @HideInDebugRender
    public static final Codec<IParticleColorType> CODEC = Codec.STRING.xmap(IParticleColorType::parse, IParticleColorType::asString);

    default public void compile(class_1799 stack, class_5819 random) {
    }

    public int tick(class_5819 var1);

    public String asString();

    default public String getString(int color) {
        return this.asString() + "[" + color + "]";
    }

    public IParticleColorType copy();

    private static IParticleColorType parse(String s) {
        if (s.startsWith("#")) {
            return new CustomParticleColorType(s);
        }
        ParticleColorTypeFactory factory = FACTORIES.get(s);
        if (factory == null) {
            return new StandardParticleColorType();
        }
        return factory.create(s);
    }

    public static interface ParticleColorTypeFactory {
        @NotNull
        public IParticleColorType create(String var1);
    }
}

