/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.texture;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.lopymine.ip.atlas.InventoryParticlesAtlasManager;
import net.lopymine.ip.config.particle.ParticleAnimationType;
import net.lopymine.ip.config.particle.ParticleConfig;
import net.lopymine.ip.debug.IDebugRenderable;
import net.lopymine.ip.element.base.ITickElement;
import net.lopymine.ip.texture.LoopParticleTextureProvider;
import net.lopymine.ip.texture.OneTimeParticleTextureProvider;
import net.lopymine.ip.texture.RandomParticleTextureProvider;
import net.lopymine.ip.texture.RandomStaticParticleTextureProvider;
import net.lopymine.ip.texture.StretchParticleTextureProvider;
import net.minecraft.class_1058;
import net.minecraft.class_2960;
import net.minecraft.class_5819;

public interface IParticleTextureProvider
extends ITickElement,
IDebugRenderable {
    public static final Map<ParticleConfig, List<class_1058>> CACHED_SPRITES = new HashMap<ParticleConfig, List<class_1058>>();

    public static void clear() {
        CACHED_SPRITES.clear();
    }

    public static IParticleTextureProvider getTextureProvider(ParticleConfig config) {
        List sprites = CACHED_SPRITES.computeIfAbsent(config, cfg -> {
            ArrayList<class_2960> textures = config.getTextures();
            return textures.stream().map(InventoryParticlesAtlasManager.getInstance()::getSprite).toList();
        });
        double animationSpeed = config.getAnimationSpeed();
        int lifeTime = config.getLifeTimeTicks();
        return switch (config.getAnimationType()) {
            default -> throw new IncompatibleClassChangeError();
            case ParticleAnimationType.STRETCH -> new StretchParticleTextureProvider(sprites, animationSpeed, lifeTime);
            case ParticleAnimationType.ONETIME -> new OneTimeParticleTextureProvider(sprites, animationSpeed, lifeTime);
            case ParticleAnimationType.LOOP -> new LoopParticleTextureProvider(sprites, animationSpeed, lifeTime);
            case ParticleAnimationType.RANDOM -> new RandomParticleTextureProvider(sprites, animationSpeed, lifeTime);
            case ParticleAnimationType.RANDOM_STATIC -> new RandomStaticParticleTextureProvider(sprites, animationSpeed, lifeTime);
        };
    }

    public class_1058 getInitializationTexture(class_5819 var1);

    public class_1058 getTexture(class_5819 var1);

    public boolean isShouldDead();
}

