/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ip.spawner.context;

import java.util.function.Function;
import lombok.Generated;
import net.lopymine.ip.config.InventoryParticlesConfig;
import net.lopymine.ip.config.sub.InventoryParticleConfig;
import net.lopymine.ip.config.sub.InventoryParticlesCoefficientsConfig;
import net.lopymine.ip.element.InventoryCursor;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public class ParticleSpawnContext {
    private static final ParticleSpawnContext CURSOR_CONTEXT = new ParticleSpawnContext(InventoryParticleConfig::isCursorSpawnEnabled, InventoryParticlesCoefficientsConfig::getCursorConfig);
    private static final ParticleSpawnContext HOVERED_SLOT_CONTEXT = new ParticleSpawnContext(InventoryParticleConfig::isHoveredSlotSpawnEnabled, InventoryParticlesCoefficientsConfig::getHoveredSlotConfig);
    private static final ParticleSpawnContext ALL_SLOTS_CONTEXT = new ParticleSpawnContext(InventoryParticleConfig::isGuiSlotsSpawnEnabled, InventoryParticlesCoefficientsConfig::getAllSlotsConfig);
    private static final ParticleSpawnContext GUI_ACTION_SLOT = new ParticleSpawnContext(InventoryParticleConfig::isGuiActionSpawnEnabled, InventoryParticlesCoefficientsConfig::getGuiActionConfig, InventoryParticlesCoefficientsConfig.ParticleCoefficientConfig::getCountCoefficient, config -> 1.0);
    private class_1799 stack;
    private int x;
    private int y;
    private double impulseX;
    private double impulseY;
    private Function<InventoryParticleConfig, Boolean> enabledFunction;
    private Function<InventoryParticlesCoefficientsConfig, InventoryParticlesCoefficientsConfig.ParticleCoefficientConfig> configFunction;
    private Function<InventoryParticlesCoefficientsConfig.ParticleCoefficientConfig, Double> countFunction;
    private Function<InventoryParticlesCoefficientsConfig.ParticleCoefficientConfig, Double> cooldownFunction;

    public ParticleSpawnContext(Function<InventoryParticleConfig, Boolean> enabledFunction, Function<InventoryParticlesCoefficientsConfig, InventoryParticlesCoefficientsConfig.ParticleCoefficientConfig> configFunction) {
        this(enabledFunction, configFunction, InventoryParticlesCoefficientsConfig.ParticleCoefficientConfig::getCountCoefficient, InventoryParticlesCoefficientsConfig.ParticleCoefficientConfig::getCooldownCoefficient);
    }

    public ParticleSpawnContext(Function<InventoryParticleConfig, Boolean> enabledFunction, Function<InventoryParticlesCoefficientsConfig, InventoryParticlesCoefficientsConfig.ParticleCoefficientConfig> configFunction, Function<InventoryParticlesCoefficientsConfig.ParticleCoefficientConfig, Double> countFunction, Function<InventoryParticlesCoefficientsConfig.ParticleCoefficientConfig, Double> cooldownFunction) {
        this.enabledFunction = enabledFunction;
        this.configFunction = configFunction;
        this.countFunction = countFunction;
        this.cooldownFunction = cooldownFunction;
    }

    public static ParticleSpawnContext cursor(InventoryCursor cursor) {
        CURSOR_CONTEXT.setStack(cursor.getCurrentStack());
        CURSOR_CONTEXT.setX(cursor.getX());
        CURSOR_CONTEXT.setY(cursor.getY());
        CURSOR_CONTEXT.setImpulseX(cursor.getSpeedX());
        CURSOR_CONTEXT.setImpulseY(cursor.getSpeedY());
        return CURSOR_CONTEXT;
    }

    public static ParticleSpawnContext hoveredSlot(class_1735 slot, int inventoryX, int inventoryY) {
        return ParticleSpawnContext.slot(HOVERED_SLOT_CONTEXT, slot, inventoryX, inventoryY);
    }

    public static ParticleSpawnContext guiActionSlot(class_1735 slot, int inventoryX, int inventoryY) {
        return ParticleSpawnContext.slot(GUI_ACTION_SLOT, slot, inventoryX, inventoryY);
    }

    public static ParticleSpawnContext slots(class_1735 slot, int inventoryX, int inventoryY) {
        return ParticleSpawnContext.slot(ALL_SLOTS_CONTEXT, slot, inventoryX, inventoryY);
    }

    @NotNull
    private static ParticleSpawnContext slot(ParticleSpawnContext context, class_1735 slot, int inventoryX, int inventoryY) {
        context.setStack(slot.method_7677());
        context.setX(inventoryX + slot.field_7873 + 8);
        context.setY(inventoryY + slot.field_7872 + 8);
        context.setImpulseX(0.0);
        context.setImpulseY(0.0);
        return context;
    }

    public double getCountCoefficient() {
        InventoryParticleConfig config = InventoryParticlesConfig.getInstance().getParticleConfig();
        Boolean enabled = this.enabledFunction.apply(config);
        if (!enabled.booleanValue()) {
            return 1.0;
        }
        return this.countFunction.apply(this.configFunction.apply(InventoryParticlesConfig.getInstance().getCoefficientsConfig()));
    }

    public double getCooldownCoefficient() {
        Boolean enabled = this.enabledFunction.apply(InventoryParticlesConfig.getInstance().getParticleConfig());
        if (!enabled.booleanValue()) {
            return 1.0;
        }
        return this.cooldownFunction.apply(this.configFunction.apply(InventoryParticlesConfig.getInstance().getCoefficientsConfig()));
    }

    @Generated
    public class_1799 getStack() {
        return this.stack;
    }

    @Generated
    public int getX() {
        return this.x;
    }

    @Generated
    public int getY() {
        return this.y;
    }

    @Generated
    public double getImpulseX() {
        return this.impulseX;
    }

    @Generated
    public double getImpulseY() {
        return this.impulseY;
    }

    @Generated
    public Function<InventoryParticleConfig, Boolean> getEnabledFunction() {
        return this.enabledFunction;
    }

    @Generated
    public Function<InventoryParticlesCoefficientsConfig, InventoryParticlesCoefficientsConfig.ParticleCoefficientConfig> getConfigFunction() {
        return this.configFunction;
    }

    @Generated
    public Function<InventoryParticlesCoefficientsConfig.ParticleCoefficientConfig, Double> getCountFunction() {
        return this.countFunction;
    }

    @Generated
    public Function<InventoryParticlesCoefficientsConfig.ParticleCoefficientConfig, Double> getCooldownFunction() {
        return this.cooldownFunction;
    }

    @Generated
    public void setStack(class_1799 stack) {
        this.stack = stack;
    }

    @Generated
    public void setX(int x) {
        this.x = x;
    }

    @Generated
    public void setY(int y) {
        this.y = y;
    }

    @Generated
    public void setImpulseX(double impulseX) {
        this.impulseX = impulseX;
    }

    @Generated
    public void setImpulseY(double impulseY) {
        this.impulseY = impulseY;
    }

    @Generated
    public void setEnabledFunction(Function<InventoryParticleConfig, Boolean> enabledFunction) {
        this.enabledFunction = enabledFunction;
    }

    @Generated
    public void setConfigFunction(Function<InventoryParticlesCoefficientsConfig, InventoryParticlesCoefficientsConfig.ParticleCoefficientConfig> configFunction) {
        this.configFunction = configFunction;
    }

    @Generated
    public void setCountFunction(Function<InventoryParticlesCoefficientsConfig.ParticleCoefficientConfig, Double> countFunction) {
        this.countFunction = countFunction;
    }

    @Generated
    public void setCooldownFunction(Function<InventoryParticlesCoefficientsConfig.ParticleCoefficientConfig, Double> cooldownFunction) {
        this.cooldownFunction = cooldownFunction;
    }
}

