/*
 * Decompiled with CFR 0.152.
 */
package com.acikek.mannequin.client;

import com.acikek.mannequin.client.SeveringSoundInstance;
import com.acikek.mannequin.client.render.LimbModel;
import com.acikek.mannequin.client.render.LimbSpecialRenderer;
import com.acikek.mannequin.mixin.client.MinecraftAccessor;
import com.acikek.mannequin.network.MannequinNetworking;
import com.acikek.mannequin.util.LimbOrientation;
import com.acikek.mannequin.util.LimbType;
import com.acikek.mannequin.util.MannequinEntity;
import com.acikek.mannequin.util.MannequinLimb;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.minecraft.class_10517;
import net.minecraft.class_1113;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5601;
import net.minecraft.class_746;
import net.minecraft.class_8685;
import net.minecraft.class_8710;

public class MannequinClient
implements ClientModInitializer {
    public static final class_5601 LEFT_LEG_LAYER = new class_5601(class_2960.method_60655((String)"mannequin", (String)"left_leg"), "main");
    public static final class_5601 RIGHT_LEG_LAYER = new class_5601(class_2960.method_60655((String)"mannequin", (String)"right_leg"), "main");
    public static final class_5601 LEFT_ARM_LAYER = new class_5601(class_2960.method_60655((String)"mannequin", (String)"left_arm"), "main");
    public static final class_5601 RIGHT_ARM_LAYER = new class_5601(class_2960.method_60655((String)"mannequin", (String)"right_arm"), "main");
    public static final class_5601 LEFT_ARM_SLIM_LAYER = new class_5601(class_2960.method_60655((String)"mannequin", (String)"left_arm_slim"), "main");
    public static final class_5601 RIGHT_ARM_SLIM_LAYER = new class_5601(class_2960.method_60655((String)"mannequin", (String)"right_arm_slim"), "main");

    public void onInitializeClient() {
        EntityModelLayerRegistry.registerModelLayer((class_5601)LEFT_LEG_LAYER, () -> LimbModel.createLayer(LimbType.LEG, LimbOrientation.LEFT, false));
        EntityModelLayerRegistry.registerModelLayer((class_5601)RIGHT_LEG_LAYER, () -> LimbModel.createLayer(LimbType.LEG, LimbOrientation.RIGHT, false));
        EntityModelLayerRegistry.registerModelLayer((class_5601)LEFT_ARM_LAYER, () -> LimbModel.createLayer(LimbType.ARM, LimbOrientation.LEFT, false));
        EntityModelLayerRegistry.registerModelLayer((class_5601)RIGHT_ARM_LAYER, () -> LimbModel.createLayer(LimbType.ARM, LimbOrientation.RIGHT, false));
        EntityModelLayerRegistry.registerModelLayer((class_5601)LEFT_ARM_SLIM_LAYER, () -> LimbModel.createLayer(LimbType.ARM, LimbOrientation.LEFT, true));
        EntityModelLayerRegistry.registerModelLayer((class_5601)RIGHT_ARM_SLIM_LAYER, () -> LimbModel.createLayer(LimbType.ARM, LimbOrientation.RIGHT, true));
        class_10517.field_55453.method_65325((Object)class_2960.method_60655((String)"mannequin", (String)"limb"), LimbSpecialRenderer.Unbaked.MAP_CODEC);
        MannequinClient.registerNetworking();
    }

    public static void playSeveringSound(class_1657 player) {
        class_310.method_1551().method_1483().method_4873((class_1113)new SeveringSoundInstance(player));
    }

    public static void registerNetworking() {
        ClientPlayNetworking.registerGlobalReceiver(MannequinNetworking.StartSevering.TYPE, (payload, context) -> {
            MannequinEntity mannequinEntity;
            class_1657 player;
            if (payload.entityId().isEmpty()) {
                return;
            }
            class_1297 entity = context.player().method_37908().method_8469(payload.entityId().getAsInt());
            if (entity instanceof class_1657 && (player = (class_1657)entity) instanceof MannequinEntity && MannequinNetworking.tryStartSevering(payload, player, mannequinEntity = (MannequinEntity)player).active()) {
                MannequinClient.playSeveringSound(player);
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(MannequinNetworking.UpdateSeveringTicksRemaining.TYPE, (payload, context) -> {
            class_746 patt0$temp = context.player();
            if (patt0$temp instanceof MannequinEntity) {
                MannequinEntity mannequinEntity = (MannequinEntity)patt0$temp;
                mannequinEntity.mannequin$getData().severingTicksRemaining = payload.ticksRemaining();
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(MannequinNetworking.StopSevering.TYPE, (payload, context) -> {
            class_746 entity;
            Object object = entity = payload.entityId().isPresent() ? context.player().method_37908().method_8469(payload.entityId().getAsInt()) : context.player();
            if (entity instanceof MannequinEntity) {
                MannequinEntity mannequinEntity = (MannequinEntity)entity;
                mannequinEntity.mannequin$stopSevering();
            }
            if (payload.entityId().isEmpty()) {
                ((MinecraftAccessor)class_310.method_1551()).setRightClickDelay(4);
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(MannequinNetworking.UpdateLimb.TYPE, (payload, context) -> {
            class_746 entity;
            Object object = entity = payload.entityId().isPresent() ? context.player().method_37908().method_8469(payload.entityId().getAsInt()) : context.player();
            if (entity instanceof MannequinEntity) {
                MannequinEntity mannequinEntity = (MannequinEntity)entity;
                MannequinLimb limb = mannequinEntity.mannequin$getData().limbs.resolve(payload.limb().type, payload.limb().orientation);
                if (limb == null) {
                    return;
                }
                if (payload.limb().severed) {
                    class_1268 hand = payload.mainHand() ? class_1268.field_5808 : class_1268.field_5810;
                    mannequinEntity.mannequin$sever(limb, hand);
                    if (entity instanceof class_1657) {
                        class_1657 player = (class_1657)entity;
                        player.method_6104(hand);
                    }
                } else if (payload.limb().profile.isPresent()) {
                    limb.profile = payload.limb().profile;
                    limb.slim = payload.limb().slim;
                    mannequinEntity.mannequin$attach(limb);
                }
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(MannequinNetworking.UpdateDoll.TYPE, (payload, context) -> {
            class_746 entity;
            Object object = entity = payload.entityId().isPresent() ? context.player().method_37908().method_8469(payload.entityId().getAsInt()) : context.player();
            if (entity instanceof MannequinEntity) {
                MannequinEntity mannequinEntity = (MannequinEntity)entity;
                if (payload.doll()) {
                    mannequinEntity.mannequin$makeDoll();
                } else {
                    mannequinEntity.mannequin$getData().doll = false;
                }
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(MannequinNetworking.UpdateMannequinEntityData.TYPE, (payload, context) -> {
            class_746 entity;
            Object object = entity = payload.entityId().isPresent() ? context.player().method_37908().method_8469(payload.entityId().getAsInt()) : context.player();
            if (entity instanceof MannequinEntity) {
                MannequinEntity mannequinEntity = (MannequinEntity)entity;
                mannequinEntity.mannequin$setData(payload.data());
                entity.method_18382();
            }
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            class_746 patt0$temp = client.field_1724;
            if (patt0$temp instanceof MannequinEntity) {
                boolean slim;
                MannequinEntity mannequinEntity = (MannequinEntity)patt0$temp;
                mannequinEntity.mannequin$getData().slim = slim = client.field_1724.method_52814().comp_1629() == class_8685.class_7920.field_41122;
                sender.sendPacket((class_8710)new MannequinNetworking.UpdateSlim(slim));
            }
        });
        ClientEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (entity instanceof class_1657 && entity instanceof MannequinEntity) {
                ClientPlayNetworking.send((class_8710)new MannequinNetworking.RequestDataUpdate(entity.method_5628()));
            }
        });
    }
}

