/*
 * Decompiled with CFR 0.152.
 */
package com.acikek.mannequin.util;

import com.acikek.mannequin.item.MannequinItems;
import com.acikek.mannequin.util.LimbOrientation;
import com.acikek.mannequin.util.LimbType;
import com.acikek.mannequin.util.MannequinEntity;
import com.acikek.mannequin.util.MannequinLimb;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_9139;
import net.minecraft.class_9296;

public record MannequinLimbs(MannequinLimb leftLeg, MannequinLimb rightLeg, MannequinLimb leftArm, MannequinLimb rightArm, MannequinLimb torso) {
    public static final Codec<MannequinLimbs> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MannequinLimb.CODEC.fieldOf("leftLeg").forGetter(MannequinLimbs::leftLeg), (App)MannequinLimb.CODEC.fieldOf("rightLeg").forGetter(MannequinLimbs::rightLeg), (App)MannequinLimb.CODEC.fieldOf("leftArm").forGetter(MannequinLimbs::leftArm), (App)MannequinLimb.CODEC.fieldOf("rightArm").forGetter(MannequinLimbs::rightArm), (App)MannequinLimb.CODEC.fieldOf("torso").forGetter(MannequinLimbs::torso)).apply((Applicative)instance, MannequinLimbs::new));
    public static final class_9139<class_2540, MannequinLimbs> STREAM_CODEC = class_9139.method_56906(MannequinLimb.STREAM_CODEC, MannequinLimbs::leftLeg, MannequinLimb.STREAM_CODEC, MannequinLimbs::rightLeg, MannequinLimb.STREAM_CODEC, MannequinLimbs::leftArm, MannequinLimb.STREAM_CODEC, MannequinLimbs::rightArm, MannequinLimb.STREAM_CODEC, MannequinLimbs::torso, MannequinLimbs::new);

    public MannequinLimbs() {
        this(new MannequinLimb(LimbType.LEG, LimbOrientation.LEFT), new MannequinLimb(LimbType.LEG, LimbOrientation.RIGHT), new MannequinLimb(LimbType.ARM, LimbOrientation.LEFT), new MannequinLimb(LimbType.ARM, LimbOrientation.RIGHT), new MannequinLimb(LimbType.TORSO, LimbOrientation.NONE));
    }

    public void setProfile(Optional<class_9296> profile) {
        this.leftLeg.profile = profile;
        this.rightLeg.profile = profile;
        this.leftArm.profile = profile;
        this.rightArm.profile = profile;
        this.torso.profile = profile;
    }

    public List<MannequinLimb> getParts() {
        return List.of(this.leftLeg, this.rightLeg, this.leftArm, this.rightArm, this.torso);
    }

    public MannequinLimb resolve(class_1309 entity, class_1799 stack, class_1268 hand) {
        MannequinEntity mannequinEntity;
        boolean right;
        boolean bl = right = hand == class_1268.field_5808;
        if (entity.method_6068() == class_1306.field_6182) {
            boolean bl2 = right = !right;
        }
        if (stack.method_31573(MannequinItems.SEVERS_HEADS) && this.leftLeg.severed && this.rightLeg.severed && entity instanceof MannequinEntity && (mannequinEntity = (MannequinEntity)entity).mannequin$getData() != null && mannequinEntity.mannequin$getData().doll) {
            return this.torso;
        }
        if (stack.method_31573(MannequinItems.SEVERS_LEGS)) {
            return right ? this.leftLeg : this.rightLeg;
        }
        if (stack.method_31573(MannequinItems.SEVERS_ARMS)) {
            return right ? this.leftArm : this.rightArm;
        }
        return null;
    }

    public MannequinLimb resolve(LimbType limbType, LimbOrientation limbOrientation) {
        return switch (limbType) {
            default -> throw new MatchException(null, null);
            case LimbType.LEG -> {
                switch (limbOrientation) {
                    case LEFT: {
                        yield this.leftLeg;
                    }
                    case RIGHT: {
                        yield this.rightLeg;
                    }
                }
                yield null;
            }
            case LimbType.ARM -> {
                switch (limbOrientation) {
                    case LEFT: {
                        yield this.leftArm;
                    }
                    case RIGHT: {
                        yield this.rightArm;
                    }
                }
                yield null;
            }
            case LimbType.TORSO -> this.torso;
        };
    }

    public MannequinLimb getArm(class_1306 arm) {
        return arm == class_1306.field_6183 ? this.rightArm : this.leftArm;
    }
}

