/*
 * Decompiled with CFR 0.152.
 */
package com.acikek.mannequin.network;

import com.acikek.mannequin.util.LimbType;
import com.acikek.mannequin.util.MannequinEntity;
import com.acikek.mannequin.util.MannequinEntityData;
import com.acikek.mannequin.util.MannequinLimb;
import java.util.OptionalInt;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class MannequinNetworking {
    public static void register() {
        PayloadTypeRegistry.playC2S().register(StartSevering.TYPE, StartSevering.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(StartSevering.TYPE, StartSevering.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(UpdateSeveringTicksRemaining.TYPE, UpdateSeveringTicksRemaining.STREAM_CODEC);
        PayloadTypeRegistry.playC2S().register(StopSevering.TYPE, StopSevering.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(StopSevering.TYPE, StopSevering.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(UpdateLimb.TYPE, UpdateLimb.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(UpdateDoll.TYPE, UpdateDoll.STREAM_CODEC);
        PayloadTypeRegistry.playC2S().register(UpdateSlim.TYPE, UpdateSlim.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(UpdateMannequinEntityData.TYPE, UpdateMannequinEntityData.STREAM_CODEC);
        PayloadTypeRegistry.playC2S().register(RequestDataUpdate.TYPE, RequestDataUpdate.STREAM_CODEC);
        MannequinNetworking.registerServer();
    }

    public static void registerServer() {
        ServerPlayNetworking.registerGlobalReceiver(StartSevering.TYPE, (payload, context) -> {
            class_3222 patt0$temp = context.player();
            if (!(patt0$temp instanceof MannequinEntity)) {
                return;
            }
            MannequinEntity mannequinEntity = (MannequinEntity)patt0$temp;
            StartSeveringResult result = MannequinNetworking.tryStartSevering(payload, (class_1657)context.player(), mannequinEntity);
            if (result.active()) {
                context.responseSender().sendPacket((class_8710)new UpdateSeveringTicksRemaining(result.ticks()));
                StartSevering watcherPayload = new StartSevering(OptionalInt.of(context.player().method_5628()), payload.mainHand());
                for (class_3222 watcher : PlayerLookup.tracking((class_1297)context.player())) {
                    ServerPlayNetworking.send((class_3222)watcher, (class_8710)watcherPayload);
                }
            } else if (result.severedLimb() == null) {
                MannequinNetworking.stopSevering(context.player(), mannequinEntity, true);
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(StopSevering.TYPE, (payload, context) -> {
            class_3222 patt0$temp = context.player();
            if (patt0$temp instanceof MannequinEntity) {
                MannequinEntity mannequinEntity = (MannequinEntity)patt0$temp;
                MannequinNetworking.stopSevering(context.player(), mannequinEntity, false);
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(UpdateSlim.TYPE, (payload, context) -> {
            class_3222 patt0$temp = context.player();
            if (patt0$temp instanceof MannequinEntity) {
                MannequinEntity mannequinEntity = (MannequinEntity)patt0$temp;
                mannequinEntity.mannequin$getData().slim = payload.slim();
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(RequestDataUpdate.TYPE, (payload, context) -> {
            MannequinEntity mannequinEntity;
            class_1297 patt0$temp = context.player().method_51469().method_8469(payload.entityId());
            if (patt0$temp instanceof MannequinEntity && (mannequinEntity = (MannequinEntity)patt0$temp).mannequin$getData() != null) {
                context.responseSender().sendPacket((class_8710)new UpdateMannequinEntityData(OptionalInt.of(payload.entityId()), mannequinEntity.mannequin$getData()));
            }
        });
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (entity instanceof MannequinEntity) {
                entity.method_18382();
            }
        });
    }

    public static StartSeveringResult tryStartSevering(StartSevering payload, class_1657 player, MannequinEntity mannequinEntity) {
        if (mannequinEntity.mannequin$getData().severing) {
            return StartSeveringResult.empty();
        }
        class_1268 hand = payload.mainHand() ? class_1268.field_5808 : class_1268.field_5810;
        class_1799 stack = player.method_5998(hand);
        MannequinLimb limbToSever = mannequinEntity.mannequin$getData().limbs.resolve((class_1309)player, stack, hand);
        if (limbToSever != null && !limbToSever.severed) {
            if (mannequinEntity.mannequin$getData().doll && limbToSever.type != LimbType.TORSO) {
                mannequinEntity.mannequin$sever(limbToSever, hand);
                return new StartSeveringResult(false, 0, limbToSever);
            }
            int severingTicks = limbToSever.getSeveringTicks(stack);
            if (severingTicks >= 0) {
                mannequinEntity.mannequin$startSevering(limbToSever, hand, severingTicks);
            }
            return new StartSeveringResult(true, severingTicks, null);
        }
        return StartSeveringResult.empty();
    }

    public static void stopSevering(class_3222 player, MannequinEntity mannequinEntity, boolean force) {
        mannequinEntity.mannequin$stopSevering();
        if (force) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new StopSevering(OptionalInt.empty()));
        }
        StopSevering watcherPayload = new StopSevering(OptionalInt.of(player.method_5628()));
        for (class_3222 watcher : PlayerLookup.tracking((class_1297)player)) {
            ServerPlayNetworking.send((class_3222)watcher, (class_8710)watcherPayload);
        }
    }

    public record StartSevering(OptionalInt entityId, boolean mainHand) implements class_8710
    {
        public static final class_8710.class_9154<StartSevering> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"mannequin", (String)"start_severing"));
        public static final class_9139<class_2540, StartSevering> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.field_54890, StartSevering::entityId, (class_9139)class_9135.field_48547, StartSevering::mainHand, StartSevering::new);

        @NotNull
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    public record UpdateSeveringTicksRemaining(int ticksRemaining) implements class_8710
    {
        public static final class_8710.class_9154<UpdateSeveringTicksRemaining> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"mannequin", (String)"update_severing_ticks_remaining"));
        public static final class_9139<class_2540, UpdateSeveringTicksRemaining> STREAM_CODEC = class_9135.field_49675.method_56432(UpdateSeveringTicksRemaining::new, UpdateSeveringTicksRemaining::ticksRemaining).method_56430();

        @NotNull
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    public record StopSevering(OptionalInt entityId) implements class_8710
    {
        public static final class_8710.class_9154<StopSevering> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"mannequin", (String)"stop_severing"));
        public static final class_9139<class_2540, StopSevering> STREAM_CODEC = class_9135.field_54890.method_56432(StopSevering::new, StopSevering::entityId).method_56430();

        @NotNull
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    public record UpdateLimb(OptionalInt entityId, boolean mainHand, MannequinLimb limb) implements class_8710
    {
        public static final class_8710.class_9154<UpdateLimb> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"mannequin", (String)"update_limb"));
        public static final class_9139<class_2540, UpdateLimb> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.field_54890, UpdateLimb::entityId, (class_9139)class_9135.field_48547, UpdateLimb::mainHand, MannequinLimb.STREAM_CODEC, UpdateLimb::limb, UpdateLimb::new);

        @NotNull
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    public record UpdateDoll(OptionalInt entityId, boolean doll) implements class_8710
    {
        public static final class_8710.class_9154<UpdateDoll> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"mannequin", (String)"update_doll"));
        public static final class_9139<class_2540, UpdateDoll> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.field_54890, UpdateDoll::entityId, (class_9139)class_9135.field_48547, UpdateDoll::doll, UpdateDoll::new);

        @NotNull
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    public record UpdateSlim(boolean slim) implements class_8710
    {
        public static final class_8710.class_9154<UpdateSlim> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"mannequin", (String)"update_slim"));
        public static final class_9139<class_2540, UpdateSlim> STREAM_CODEC = class_9135.field_48547.method_56432(UpdateSlim::new, UpdateSlim::slim).method_56430();

        @NotNull
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    public record UpdateMannequinEntityData(OptionalInt entityId, MannequinEntityData data) implements class_8710
    {
        public static final class_8710.class_9154<UpdateMannequinEntityData> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"mannequin", (String)"update_mannequin_entity_data"));
        public static final class_9139<class_2540, UpdateMannequinEntityData> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.field_54890, UpdateMannequinEntityData::entityId, MannequinEntityData.STREAM_CODEC, UpdateMannequinEntityData::data, UpdateMannequinEntityData::new);

        @NotNull
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    public record RequestDataUpdate(int entityId) implements class_8710
    {
        public static final class_8710.class_9154<RequestDataUpdate> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"mannequin", (String)"request_data_update"));
        public static final class_9139<class_2540, RequestDataUpdate> STREAM_CODEC = class_9135.field_49675.method_56432(RequestDataUpdate::new, RequestDataUpdate::entityId).method_56430();

        @NotNull
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    public record StartSeveringResult(boolean active, int ticks, MannequinLimb severedLimb) {
        public static StartSeveringResult empty() {
            return new StartSeveringResult(false, 0, null);
        }
    }
}

