/*
 * Decompiled with CFR 0.152.
 */
package com.acikek.mannequin.client.render;

import com.acikek.mannequin.client.MannequinClient;
import com.acikek.mannequin.client.render.LimbModel;
import com.acikek.mannequin.util.LimbOrientation;
import com.acikek.mannequin.util.LimbType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_10515;
import net.minecraft.class_1068;
import net.minecraft.class_1071;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_5601;
import net.minecraft.class_811;
import net.minecraft.class_8685;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class LimbSpecialRenderer
implements class_10515<Argument> {
    private final Map<class_9296, Argument> updatedProfiles = new HashMap<class_9296, Argument>();
    private final class_1071 skinManager;
    private final LimbModel model;
    private final Argument defaultArgument;

    public LimbSpecialRenderer(class_1071 skinManager, LimbModel model, Argument argument) {
        this.skinManager = skinManager;
        this.model = model;
        this.defaultArgument = argument;
    }

    @Nullable
    public Argument extractArgument(class_1799 itemStack) {
        class_9296 profile = (class_9296)itemStack.method_58694(class_9334.field_49617);
        if (profile == null) {
            return null;
        }
        Argument argument = this.updatedProfiles.get(profile);
        if (argument != null) {
            return argument;
        }
        class_9296 resolved = profile.method_72087();
        return resolved != null ? this.createAndCacheIfTextureIsUnpacked(resolved) : null;
    }

    @Nullable
    private Argument createAndCacheIfTextureIsUnpacked(class_9296 profile) {
        class_8685 skin = this.skinManager.method_72180(profile.comp_2413(), null);
        if (skin == null) {
            return null;
        }
        Argument argument = new Argument(class_1921.method_23580((class_2960)skin.comp_1626()));
        this.updatedProfiles.put(profile, argument);
        return argument;
    }

    public void render(@Nullable Argument argument, class_811 itemDisplayContext, class_4587 poseStack, class_4597 multiBufferSource, int i, int j, boolean bl) {
        Argument arg = Objects.requireNonNullElse(argument, this.defaultArgument);
        poseStack.method_22903();
        poseStack.method_46416(0.5f, itemDisplayContext == class_811.field_4318 ? 0.0f : 1.5f, 0.5f);
        poseStack.method_22905(-1.0f, -1.0f, 1.0f);
        if (itemDisplayContext == class_811.field_4318) {
            // empty if block
        }
        class_4588 vertexConsumer = multiBufferSource.getBuffer(arg.renderType());
        this.model.method_60879(poseStack, vertexConsumer, i, class_4608.field_21444);
        poseStack.method_22909();
    }

    public void method_72175(Set<Vector3f> set) {
        class_4587 poseStack = new class_4587();
        poseStack.method_46416(0.5f, 0.0f, 0.5f);
        poseStack.method_22905(-1.0f, -1.0f, 1.0f);
        this.model.method_63512().method_72152(poseStack, set);
    }

    public record Argument(class_1921 renderType) {
    }

    public record Unbaked(LimbType limbType, LimbOrientation limbOrientation, boolean slim) implements class_10515.class_10516
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LimbType.CODEC.fieldOf("limb_type").forGetter(Unbaked::limbType), (App)LimbOrientation.CODEC.fieldOf("limb_orientation").forGetter(Unbaked::limbOrientation), (App)Codec.BOOL.fieldOf("limb_slim").forGetter(Unbaked::slim)).apply((Applicative)instance, Unbaked::new));

        @NotNull
        public MapCodec<? extends class_10515.class_10516> method_65696() {
            return MAP_CODEC;
        }

        @NotNull
        public class_10515<?> method_65698(class_5599 entityModelSet) {
            class_5601 layer = this.limbType == LimbType.LEG ? (this.limbOrientation == LimbOrientation.LEFT ? MannequinClient.LEFT_LEG_LAYER : MannequinClient.RIGHT_LEG_LAYER) : (this.limbOrientation == LimbOrientation.LEFT ? (this.slim ? MannequinClient.LEFT_ARM_SLIM_LAYER : MannequinClient.LEFT_ARM_LAYER) : (this.slim ? MannequinClient.RIGHT_ARM_SLIM_LAYER : MannequinClient.RIGHT_ARM_LAYER));
            LimbModel model = new LimbModel(entityModelSet.method_32072(layer));
            return new LimbSpecialRenderer(class_310.method_1551().method_1582(), model, new Argument(class_1921.method_23580((class_2960)class_1068.method_4649())));
        }
    }
}

