/*
 * Decompiled with CFR 0.152.
 */
package com.acikek.mannequin.mixin;

import com.acikek.mannequin.Mannequin;
import com.acikek.mannequin.network.MannequinNetworking;
import com.acikek.mannequin.sound.MannequinSounds;
import com.acikek.mannequin.util.LimbType;
import com.acikek.mannequin.util.MannequinEntity;
import com.acikek.mannequin.util.MannequinEntityData;
import com.acikek.mannequin.util.MannequinLimb;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.ArrayList;
import java.util.OptionalInt;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_10630;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4048;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
implements MannequinEntity {
    @Shadow
    @Final
    protected class_10630 field_56535;
    @Unique
    private MannequinEntityData data;

    @Shadow
    public abstract class_1799 method_5998(class_1268 var1);

    @Shadow
    @Nullable
    public abstract class_1324 method_5996(class_6880<class_1320> var1);

    @Shadow
    public abstract void method_56078(@Nullable class_3414 var1);

    @Shadow
    public abstract boolean method_6059(class_6880<class_1291> var1);

    @Shadow
    public abstract class_1306 method_6068();

    @Shadow
    @Nullable
    protected abstract class_1542 method_67517(class_1799 var1, boolean var2, boolean var3);

    @Shadow
    public abstract void method_6122(class_1268 var1, class_1799 var2);

    @Shadow
    public abstract void method_5673(class_1304 var1, class_1799 var2);

    @Shadow
    public abstract float method_55693();

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void mannequin$init(class_1299<?> entityType, class_1937 level, CallbackInfo ci) {
        if ((class_1309)this instanceof class_1657) {
            this.data = new MannequinEntityData();
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void mannequin$tick(CallbackInfo ci) {
        if (this.data == null) {
            return;
        }
        this.mannequin$tickDamage();
        if (this.data.severing) {
            --this.data.severingTicksRemaining;
            ++this.data.severingTicksElapsed;
            if (this.data.severingTicksRemaining <= 0) {
                this.mannequin$sever();
            }
        }
    }

    @Unique
    private void mannequin$tickDamage() {
        class_1937 class_19372;
        if (this.data.doll || !this.data.severing && this.data.ticksToBleed == 0) {
            return;
        }
        if (!this.data.severing && this.data.ticksToBleed > 0 && this.data.damageTicksElapsed >= this.data.ticksToBleed) {
            this.data.damageTicksElapsed = 0;
            this.data.ticksToBleed = 0;
            return;
        }
        ++this.data.damageTicksElapsed;
        if (this.data.ticksToBleed > 0) {
            ++this.data.totalBleedingTicks;
            if (this.data.totalBleedingTicks >= 600) {
                this.mannequin$makeDoll();
                return;
            }
        }
        if ((this.data.severing || !this.method_6059((class_6880<class_1291>)class_1294.field_5906)) && this.data.damageTicksElapsed % (this.data.severing ? 10 : 20) == 0 && (class_19372 = ((class_1309)this).method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_1282 damageSource = ((class_1309)this).method_37908().method_48963().method_48795(Mannequin.BLEEDING_DAMAGE_TYPE);
            class_243 velocity = ((class_1309)this).method_18798();
            ((class_1309)this).method_64397(serverLevel, damageSource, this.data.severing ? 2.0f : 1.0f);
            ((class_1309)this).method_18799(velocity.method_18805(0.3, 0.3, 0.3));
        }
    }

    @Unique
    private void mannequin$sever() {
        if (this.data.severingLimb == null || this.data.severingHand == null) {
            return;
        }
        this.data.ticksToBleed = this.data.damageTicksElapsed * 2;
        this.mannequin$sever(this.data.severingLimb, this.data.severingHand);
    }

    @ModifyReturnValue(method={"getDimensions"}, at={@At(value="RETURN")})
    private class_4048 mannequin$resize(class_4048 original) {
        if (this.data == null) {
            return original;
        }
        if (this.data.limbs.torso().severed) {
            return Mannequin.HEAD_ONLY_DIMENSIONS.method_18383(this.method_55693());
        }
        if (this.data.limbs.leftLeg().severed && this.data.limbs.rightLeg().severed) {
            return Mannequin.LEGLESS_DIMENSIONS.method_18383(this.method_55693());
        }
        return original;
    }

    @Inject(method={"getItemInHand"}, at={@At(value="HEAD")}, cancellable=true)
    private void mannequin$getItemInHand(class_1268 interactionHand, CallbackInfoReturnable<class_1799> cir) {
        class_1306 arm;
        if (this.data == null) {
            return;
        }
        class_1306 class_13062 = arm = interactionHand == class_1268.field_5808 ? this.method_6068() : this.method_6068().method_5928();
        if (this.data.limbs.getArm((class_1306)arm).severed) {
            cir.setReturnValue((Object)class_1799.field_8037);
        }
    }

    @Inject(method={"canUseSlot"}, at={@At(value="HEAD")}, cancellable=true)
    private void mannequin$canUseSlot(class_1304 equipmentSlot, CallbackInfoReturnable<Boolean> cir) {
        if (this.mannequin$isSlotSevered(equipmentSlot)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"getItemBySlot"}, at={@At(value="HEAD")}, cancellable=true)
    private void mannequin$getItemBySlot(class_1304 equipmentSlot, CallbackInfoReturnable<class_1799> cir) {
        if (this.mannequin$isSlotSevered(equipmentSlot)) {
            cir.setReturnValue((Object)class_1799.field_8037);
        }
    }

    @Unique
    private boolean mannequin$isSlotSevered(class_1304 equipmentSlot) {
        if (this.data == null) {
            return false;
        }
        if (this.data.limbs.torso().severed) {
            return equipmentSlot != class_1304.field_6169;
        }
        return (equipmentSlot == class_1304.field_6166 || equipmentSlot == class_1304.field_6172) && this.data.limbs.leftLeg().severed && this.data.limbs.rightLeg().severed || equipmentSlot == class_1304.field_6173 && this.data.limbs.getArm((class_1306)this.method_6068()).severed || equipmentSlot == class_1304.field_6171 && this.data.limbs.getArm((class_1306)this.method_6068().method_5928()).severed;
    }

    @Override
    public MannequinEntityData mannequin$getData() {
        return this.data;
    }

    @Override
    public void mannequin$setData(MannequinEntityData data) {
        this.data = data;
    }

    @Override
    public void mannequin$startSevering(MannequinLimb limbToSever, class_1268 hand, int ticks) {
        this.data.severing = true;
        this.data.severingLimb = limbToSever;
        this.data.severingHand = hand;
        this.data.severingTicksRemaining = ticks;
        class_1324 attribute = this.method_5996((class_6880<class_1320>)class_5134.field_23719);
        if (attribute != null && !attribute.method_6196(Mannequin.SEVERING_SLOWNESS.comp_2447())) {
            attribute.method_26835(Mannequin.SEVERING_SLOWNESS);
        }
    }

    @Override
    public void mannequin$stopSevering() {
        this.data.severing = false;
        this.data.severingLimb = null;
        this.data.severingHand = null;
        this.data.severingTicksRemaining = 0;
        this.data.severingTicksElapsed = 0;
        this.data.damageTicksElapsed = 0;
        class_1324 attribute = this.method_5996((class_6880<class_1320>)class_5134.field_23719);
        if (attribute != null) {
            attribute.method_6202(Mannequin.SEVERING_SLOWNESS);
        }
    }

    @Override
    public void mannequin$sever(MannequinLimb limb, class_1268 hand) {
        class_1799 stack22;
        class_1799 limbStack;
        class_1309 class_13092 = (class_1309)this;
        if (!(class_13092 instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)class_13092;
        limb.severed = true;
        ArrayList<class_1799> drop = new ArrayList<class_1799>();
        if (limb.type == LimbType.ARM) {
            class_1268 severedHand = hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808;
            drop.add(this.mannequin$getItemInHand(severedHand));
            this.method_6122(severedHand, class_1799.field_8037);
        } else if (limb.type == LimbType.TORSO) {
            for (MannequinLimb mannequinLimb : this.data.limbs.getParts()) {
                if (mannequinLimb.type == LimbType.TORSO || mannequinLimb.severed) continue;
                mannequinLimb.severed = true;
                drop.add(mannequinLimb.getLimbItemStack(player));
                if (mannequinLimb.type != LimbType.ARM) continue;
                class_1268 partHand = this.method_6068() == mannequinLimb.orientation.getHumanoidArm() ? class_1268.field_5808 : class_1268.field_5810;
                drop.add(this.mannequin$getItemInHand(partHand));
                this.method_6122(partHand, class_1799.field_8037);
            }
            drop.add(this.mannequin$getItemBySlot(class_1304.field_6174));
            this.method_5673(class_1304.field_6174, class_1799.field_8037);
        }
        if ((limb.type == LimbType.TORSO || limb.type == LimbType.LEG) && this.data.limbs.leftLeg().severed && this.data.limbs.rightLeg().severed) {
            drop.add(this.mannequin$getItemBySlot(class_1304.field_6166));
            drop.add(this.mannequin$getItemBySlot(class_1304.field_6172));
            this.method_5673(class_1304.field_6166, class_1799.field_8037);
            this.method_5673(class_1304.field_6172, class_1799.field_8037);
        }
        if (!(limbStack = limb.getLimbItemStack(player)).method_7960()) {
            drop.add(limbStack);
        }
        for (class_1799 stack22 : drop) {
            class_1542 entity;
            if (stack22.method_7960() || (entity = this.method_67517(stack22, false, false)) == null) continue;
            player.method_37908().method_8649((class_1297)entity);
        }
        this.method_5998(hand).method_71012(5, (class_1309)this, hand);
        ((class_1309)this).method_18382();
        this.method_56078(MannequinSounds.LIMB_SNAP);
        stack22 = (class_1309)this;
        if (stack22 instanceof class_3222) {
            class_3222 class_32222 = (class_3222)stack22;
            boolean mainHand = hand == class_1268.field_5808;
            ServerPlayNetworking.send((class_3222)class_32222, (class_8710)new MannequinNetworking.UpdateLimb(OptionalInt.empty(), mainHand, limb));
            MannequinNetworking.UpdateLimb watcherPayload = new MannequinNetworking.UpdateLimb(OptionalInt.of(class_32222.method_5628()), mainHand, limb);
            for (class_3222 watcher : PlayerLookup.tracking((class_1297)class_32222)) {
                ServerPlayNetworking.send((class_3222)watcher, (class_8710)watcherPayload);
            }
        }
        this.mannequin$stopSevering();
    }

    @Override
    public void mannequin$attach(MannequinLimb limb) {
        limb.severed = false;
        ((class_1309)this).method_18382();
        this.method_56078(class_3417.field_14718);
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_13092;
            MannequinNetworking.UpdateLimb watcherPayload = new MannequinNetworking.UpdateLimb(OptionalInt.of(serverPlayer.method_5628()), false, limb);
            for (class_3222 watcher : PlayerLookup.tracking((class_1297)serverPlayer)) {
                ServerPlayNetworking.send((class_3222)watcher, (class_8710)watcherPayload);
            }
        }
    }

    @Override
    public void mannequin$makeDoll() {
        this.data.damageTicksElapsed = 0;
        this.data.totalBleedingTicks = 0;
        this.data.ticksToBleed = 0;
        this.data.doll = true;
        this.method_56078(class_3417.field_15214);
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_13092;
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new MannequinNetworking.UpdateDoll(OptionalInt.empty(), true));
            MannequinNetworking.UpdateDoll watcherPayload = new MannequinNetworking.UpdateDoll(OptionalInt.of(serverPlayer.method_5628()), true);
            for (class_3222 watcher : PlayerLookup.tracking((class_1297)serverPlayer)) {
                ServerPlayNetworking.send((class_3222)watcher, (class_8710)watcherPayload);
            }
        }
    }

    @Override
    public class_1799 mannequin$getItemBySlot(class_1304 slot) {
        return this.field_56535.method_66659(slot);
    }

    @Override
    public class_1799 mannequin$getItemInHand(class_1268 hand) {
        return this.mannequin$getItemBySlot(hand == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void mannequin$addSaveData(class_11372 valueOutput, CallbackInfo ci) {
        if (this.data != null) {
            valueOutput.method_71468("mannequin$entity_data", MannequinEntityData.CODEC, (Object)this.data);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void mannequin$readSaveData(class_11368 valueInput, CallbackInfo ci) {
        if (this.data != null) {
            valueInput.method_71426("mannequin$entity_data", MannequinEntityData.CODEC).ifPresent(data -> {
                this.data = data;
            });
        }
    }
}

