/*
 * Decompiled with CFR 0.152.
 */
package com.acikek.mannequin.util;

import com.acikek.mannequin.util.MannequinLimb;
import com.acikek.mannequin.util.MannequinLimbs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_2540;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class MannequinEntityData {
    public MannequinLimbs limbs;
    public boolean severing;
    public boolean doll;
    @Nullable
    public MannequinLimb severingLimb;
    @Nullable
    public class_1268 severingHand;
    public int severingTicksRemaining;
    public int severingTicksElapsed;
    public int damageTicksElapsed;
    public int ticksToBleed;
    public int totalBleedingTicks;
    public boolean slim;
    public static final Codec<MannequinEntityData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MannequinLimbs.CODEC.fieldOf("limbs").forGetter(data -> data.limbs), (App)Codec.BOOL.fieldOf("severing").forGetter(data -> data.severing), (App)Codec.BOOL.fieldOf("doll").forGetter(data -> data.doll), (App)Codec.INT.optionalFieldOf("severing_limb_index").forGetter(MannequinEntityData::getSeveringLimbIndex), (App)Codec.BOOL.optionalFieldOf("severing_hand_main").forGetter(MannequinEntityData::getSeveringHandMain), (App)Codec.INT.fieldOf("severing_ticks_remaining").forGetter(data -> data.severingTicksRemaining), (App)Codec.INT.fieldOf("severing_ticks_elapsed").forGetter(data -> data.severingTicksElapsed), (App)Codec.INT.fieldOf("damage_ticks_remaining").forGetter(data -> data.damageTicksElapsed), (App)Codec.INT.fieldOf("ticks_to_bleed").forGetter(data -> data.ticksToBleed), (App)Codec.INT.fieldOf("total_bleeding_ticks").forGetter(data -> data.totalBleedingTicks), (App)Codec.BOOL.fieldOf("slim").forGetter(data -> data.slim)).apply((Applicative)instance, MannequinEntityData::new));
    public static final class_9139<class_2540, MannequinEntityData> STREAM_CODEC = class_9135.method_56368(CODEC).method_56430();

    public MannequinEntityData(MannequinLimbs limbs, boolean severing, boolean doll, Optional<Integer> severingLimbIndex, Optional<Boolean> severingHandMain, int severingTicksRemaining, int severingTicksElapsed, int damageTicksElapsed, int ticksToBleed, int totalBleedingTicks, boolean slim) {
        this.limbs = limbs;
        this.severing = severing;
        this.doll = doll;
        this.severingLimb = severingLimbIndex.map(index -> limbs.getParts().get((int)index)).orElse(null);
        this.severingHand = severingHandMain.map(main -> main != false ? class_1268.field_5808 : class_1268.field_5810).orElse(null);
        this.severingTicksRemaining = severingTicksRemaining;
        this.damageTicksElapsed = damageTicksElapsed;
        this.ticksToBleed = ticksToBleed;
        this.totalBleedingTicks = totalBleedingTicks;
        this.slim = slim;
    }

    public MannequinEntityData() {
        this(new MannequinLimbs(), false, false, Optional.empty(), Optional.empty(), 0, 0, 0, 0, 0, false);
    }

    public Optional<Integer> getSeveringLimbIndex() {
        return Optional.ofNullable(this.severingLimb).map(limb -> this.limbs.getParts().indexOf(limb));
    }

    public Optional<Boolean> getSeveringHandMain() {
        return Optional.ofNullable(this.severingHand).map(hand -> hand == class_1268.field_5808);
    }

    public String toString() {
        return "MannequinEntityData{limbs=" + String.valueOf(this.limbs) + ", severing=" + this.severing + ", doll=" + this.doll + ", severingLimb=" + String.valueOf(this.severingLimb) + ", severingHand=" + String.valueOf(this.severingHand) + ", severingTicksRemaining=" + this.severingTicksRemaining + ", severingTicksElapsed=" + this.severingTicksElapsed + ", damageTicksElapsed=" + this.damageTicksElapsed + ", ticksToBleed=" + this.ticksToBleed + ", totalBleedingTicks=" + this.totalBleedingTicks + ", slim=" + this.slim + "}";
    }
}

