/*
 * Decompiled with CFR 0.152.
 */
package com.acikek.mannequin.command;

import com.acikek.mannequin.util.LimbOrientation;
import com.acikek.mannequin.util.LimbType;
import com.acikek.mannequin.util.MannequinEntity;
import com.acikek.mannequin.util.MannequinLimb;
import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class MannequinCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder mannequin = (LiteralArgumentBuilder)class_2170.method_9247((String)"mannequin").requires((Predicate)class_2170.method_71774((int)2));
        LiteralArgumentBuilder doll = class_2170.method_9247((String)"doll");
        MannequinCommand.executesSelfOrTargets(doll, MannequinCommand::doll);
        LiteralArgumentBuilder sever = class_2170.method_9247((String)"sever");
        for (LimbType limbType : LimbType.values()) {
            LiteralArgumentBuilder limbNode = class_2170.method_9247((String)limbType.name);
            if (limbType != LimbType.TORSO) {
                for (LimbOrientation limbOrientation : LimbOrientation.values()) {
                    if (limbOrientation == LimbOrientation.NONE) continue;
                    LiteralArgumentBuilder orientationNode = class_2170.method_9247((String)limbOrientation.name);
                    MannequinCommand.executesSelfOrTargets(orientationNode, (source, entities) -> MannequinCommand.sever(source, limbType, limbOrientation, entities));
                    limbNode.then((ArgumentBuilder)orientationNode);
                }
            } else {
                MannequinCommand.executesSelfOrTargets(limbNode, (source, entities) -> MannequinCommand.sever(source, limbType, null, entities));
            }
            sever.then((ArgumentBuilder)limbNode);
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)mannequin.then((ArgumentBuilder)doll)).then((ArgumentBuilder)sever));
    }

    public static <T extends ArgumentBuilder<class_2168, T>> void executesSelfOrTargets(ArgumentBuilder<class_2168, T> builder, BiFunction<class_2168, Collection<class_3222>, Integer> executor) {
        builder.executes(context -> (Integer)executor.apply((class_2168)context.getSource(), (Collection<class_3222>)ImmutableList.of((Object)((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(context -> (Integer)executor.apply((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"targets"))));
    }

    public static int doll(class_2168 source, Collection<class_3222> players) {
        for (class_3222 player : players) {
            if (!(player instanceof MannequinEntity)) continue;
            MannequinEntity mannequinEntity = (MannequinEntity)player;
            mannequinEntity.mannequin$makeDoll();
        }
        if (players.size() == 1) {
            source.method_9226(() -> class_2561.method_43469((String)"command.mannequin.doll.success.single", (Object[])new Object[]{((class_3222)players.iterator().next()).method_5476()}), true);
        } else {
            source.method_9226(() -> class_2561.method_43469((String)"command.mannequin.doll.success.multiple", (Object[])new Object[]{players.size()}), true);
        }
        return players.size();
    }

    public static int sever(class_2168 source, LimbType type, LimbOrientation orientation, Collection<class_3222> players) {
        for (class_3222 player : players) {
            if (!(player instanceof MannequinEntity)) continue;
            MannequinEntity mannequinEntity = (MannequinEntity)player;
            MannequinLimb limbToSever = mannequinEntity.mannequin$getData().limbs.resolve(type, orientation);
            class_1268 severingHand = class_1268.field_5808;
            if (type == LimbType.ARM && player.method_6068() == (orientation == LimbOrientation.RIGHT ? class_1306.field_6183 : class_1306.field_6182)) {
                severingHand = class_1268.field_5810;
            }
            mannequinEntity.mannequin$sever(limbToSever, severingHand);
        }
        class_5250 orientationDescription = orientation != null ? class_2561.method_43471((String)("command.mannequin.sever.limbOrientation." + orientation.name)) : class_2561.method_43473();
        class_5250 limbDescription = class_2561.method_43469((String)("command.mannequin.sever.limbType." + type.name), (Object[])new Object[]{orientationDescription});
        if (players.size() == 1) {
            source.method_9226(() -> class_2561.method_43469((String)"command.mannequin.sever.success.single", (Object[])new Object[]{((class_3222)players.iterator().next()).method_5476(), limbDescription}), true);
        } else {
            source.method_9226(() -> class_2561.method_43469((String)"command.mannequin.sever.success.multiple", (Object[])new Object[]{limbDescription, players.size()}), true);
        }
        return players.size();
    }
}

