/*
 * Decompiled with CFR 0.152.
 */
package com.acikek.mannequin.util;

import com.acikek.mannequin.item.LimbItem;
import com.acikek.mannequin.item.MannequinItems;
import com.acikek.mannequin.util.LimbOrientation;
import com.acikek.mannequin.util.LimbType;
import com.acikek.mannequin.util.MannequinEntity;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9296;
import net.minecraft.class_9334;

public class MannequinLimb {
    public static final Codec<MannequinLimb> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LimbType.CODEC.fieldOf("type").forGetter(limb -> limb.type), (App)LimbOrientation.CODEC.fieldOf("orientation").forGetter(limb -> limb.orientation), (App)Codec.BOOL.fieldOf("severed").forGetter(limb -> limb.severed), (App)Codec.BOOL.optionalFieldOf("slim").forGetter(limb -> limb.slim), (App)class_9296.field_49359.optionalFieldOf("profile").forGetter(limb -> limb.profile)).apply((Applicative)instance, MannequinLimb::new));
    public static final class_9139<class_2540, MannequinLimb> STREAM_CODEC = class_9139.method_56906(LimbType.STREAM_CODEC, limb -> limb.type, LimbOrientation.STREAM_CODEC, limb -> limb.orientation, (class_9139)class_9135.field_48547, limb -> limb.severed, (class_9139)class_9135.method_56382((class_9139)class_9135.field_48547), limb -> limb.slim, (class_9139)class_9135.method_56382((class_9139)class_9296.field_49360), limb -> limb.profile, MannequinLimb::new);
    public final LimbType type;
    public final LimbOrientation orientation;
    public boolean severed;
    public Optional<Boolean> slim;
    public Optional<class_9296> profile;

    public MannequinLimb(LimbType type, LimbOrientation orientation, boolean severed, Optional<Boolean> slim, Optional<class_9296> profile) {
        this.type = type;
        this.orientation = orientation;
        this.severed = severed;
        this.slim = slim;
        this.profile = profile;
    }

    public MannequinLimb(LimbType type, LimbOrientation orientation) {
        this(type, orientation, false, Optional.empty(), Optional.empty());
    }

    public class_1799 getLimbItemStack(class_1657 player) {
        if (this.type == LimbType.TORSO) {
            return class_1799.field_8037;
        }
        class_1799 stack = (this.type == LimbType.LEG ? MannequinItems.LEG : MannequinItems.ARM).method_7854();
        stack.method_57379(LimbOrientation.DATA_COMPONENT_TYPE, (Object)this.orientation);
        stack.method_57379(class_9334.field_49617, (Object)this.profile.orElseGet(() -> new class_9296(player.method_7334())));
        if (player instanceof MannequinEntity) {
            MannequinEntity mannequinEntity = (MannequinEntity)player;
            stack.method_57379(LimbItem.SLIM_COMPONENT_TYPE, (Object)this.slim.orElseGet(() -> mannequinEntity.mannequin$getData().slim));
        }
        return stack;
    }

    public int getSeveringTicks(class_1799 stack) {
        boolean leg;
        boolean bl = leg = this.type == LimbType.LEG;
        if (stack.method_31573(MannequinItems.SEVER_TIER_1)) {
            return leg ? 160 : 120;
        }
        if (stack.method_31573(MannequinItems.SEVER_TIER_2)) {
            return leg ? 100 : 80;
        }
        if (stack.method_31573(MannequinItems.SEVER_TIER_3)) {
            return 50;
        }
        return -1;
    }

    public boolean isBaseVisible(GameProfile profile) {
        return !this.severed && (this.profile.isEmpty() || this.profile.get().comp_2413().equals((Object)profile));
    }

    public String toString() {
        return "MannequinLimb{type=" + String.valueOf((Object)this.type) + ", orientation=" + String.valueOf((Object)this.orientation) + ", severed=" + this.severed + ", slim=" + String.valueOf(this.slim) + ", profile=" + this.profile.flatMap(class_9296::comp_2410).orElse("<none>") + "}";
    }
}

