/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.inventory;

import com.tom.storagemod.components.WorldPos;
import com.tom.storagemod.inventory.IInventoryLink;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.class_5321;
import net.minecraft.class_7225;

public class RemoteConnections
extends class_18 {
    private static final String CONNECTIONS_TAG = "connections";
    public static final String CHANNEL_ID = "id";
    public static final String OWNER_ID = "owner";
    public static final String PUBLIC_TAG = "public";
    public static final String DISPLAY_NAME = "name";
    private static final String ID = "toms_storage_rc";
    private static final class_18.class_8645<RemoteConnections> FACTORY = new class_18.class_8645(RemoteConnections::new, RemoteConnections::new, class_4284.field_19212);
    public static final String OWNER_NAME = "owner_name";
    private Map<UUID, Channel> connections = new HashMap<UUID, Channel>();

    private RemoteConnections() {
    }

    private RemoteConnections(class_2487 tag, class_7225.class_7874 provider) {
        class_2499 list = tag.method_10554(CONNECTIONS_TAG, 10);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 t = list.method_10602(i);
            UUID channel = t.method_25926(CHANNEL_ID);
            this.connections.put(channel, new Channel(t));
        }
    }

    public static RemoteConnections get(class_1937 world) {
        class_3218 sw = (class_3218)world;
        return (RemoteConnections)sw.method_8503().method_30002().method_17983().method_17924(FACTORY, ID);
    }

    public class_2487 method_75(class_2487 tag, class_7225.class_7874 provider) {
        class_2499 list = new class_2499();
        this.connections.forEach((k, v) -> {
            class_2487 t = new class_2487();
            t.method_25927(CHANNEL_ID, k);
            v.save(t);
            list.add((Object)t);
        });
        tag.method_10566(CONNECTIONS_TAG, (class_2520)list);
        return tag;
    }

    public Channel getChannel(UUID connection) {
        return this.connections.get(connection);
    }

    public UUID makeChannel(String name, boolean isPublic, class_1657 owner) {
        UUID id = UUID.randomUUID();
        if (((String)name).isEmpty() || ((String)name).length() > 50) {
            name = "Channel " + System.currentTimeMillis();
        }
        this.connections.put(id, new Channel(owner.method_7334().getId(), owner.method_7334().getName(), isPublic, (String)name));
        this.method_80();
        return id;
    }

    public void removeChannel(UUID id, UUID player) {
        Channel c = this.connections.get(id);
        if (c != null && c.owner.equals(player)) {
            this.connections.remove(id);
            this.method_80();
        }
    }

    public void editChannel(UUID id, boolean pub, UUID player) {
        Channel c = this.connections.get(id);
        if (c != null && c.owner.equals(player)) {
            c.publicChannel = pub;
            this.method_80();
        }
    }

    public void invalidateCache(UUID id) {
        Channel c = this.connections.get(id);
        if (c != null) {
            c.connectors.clear();
        }
    }

    public Stream<Map.Entry<UUID, Channel>> streamChannels(class_1657 player) {
        return this.connections.entrySet().stream().filter(c -> ((Channel)c.getValue()).canAccess(player));
    }

    public static class Channel {
        public Set<WorldPos> connectors = new HashSet<WorldPos>();
        public UUID owner;
        public String ownerName;
        public boolean publicChannel;
        public String displayName;

        public Channel(UUID owner, String ownerName, boolean publicChannel, String displayName) {
            this.owner = owner;
            this.ownerName = ownerName;
            this.publicChannel = publicChannel;
            this.displayName = displayName;
        }

        private Channel(class_2487 t) {
            this(t.method_25926(RemoteConnections.OWNER_ID), t.method_10558(RemoteConnections.OWNER_NAME), t.method_10577(RemoteConnections.PUBLIC_TAG), t.method_10558(RemoteConnections.DISPLAY_NAME));
        }

        public void register(class_3218 world, class_2338 blockPos) {
            WorldPos pos = new WorldPos((class_5321<class_1937>)world.method_27983(), blockPos);
            this.connectors.add(pos);
        }

        public Set<IInventoryLink> findOthers(class_3218 world, class_2338 blockPos, int lvl) {
            WorldPos pos = new WorldPos((class_5321<class_1937>)world.method_27983(), blockPos);
            this.connectors.add(pos);
            HashSet<IInventoryLink> found = new HashSet<IInventoryLink>();
            Iterator<WorldPos> posItr = this.connectors.iterator();
            while (posItr.hasNext()) {
                WorldPos dimPos = posItr.next();
                if (dimPos.equals(pos)) continue;
                class_2586 te = dimPos.getBlockEntity(world);
                if (te instanceof IInventoryLink) {
                    IInventoryLink link = (IInventoryLink)te;
                    if (!link.isAccessibleFrom(world, blockPos, lvl)) continue;
                    found.add(link);
                    continue;
                }
                posItr.remove();
            }
            return found;
        }

        public void save(class_2487 t) {
            t.method_25927(RemoteConnections.OWNER_ID, this.owner);
            t.method_10556(RemoteConnections.PUBLIC_TAG, this.publicChannel);
            t.method_10582(RemoteConnections.DISPLAY_NAME, this.displayName);
            t.method_10582(RemoteConnections.OWNER_NAME, this.ownerName);
        }

        public boolean canAccess(class_1657 player) {
            return this.publicChannel || this.owner.equals(player.method_5667());
        }
    }
}

