/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.jei;

import com.tom.storagemod.Content;
import com.tom.storagemod.inventory.StoredItemStack;
import com.tom.storagemod.menu.CraftingTerminalMenu;
import com.tom.storagemod.util.IAutoFillTerminal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public class CraftingTerminalTransferHandler<C extends class_1703>
implements IRecipeTransferHandler<C, class_8786<class_3955>> {
    private final Class<C> containerClass;
    private final IRecipeTransferHandlerHelper helper;
    private static final IRecipeTransferError ERROR_INSTANCE = new IRecipeTransferError(){

        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.INTERNAL;
        }
    };

    public CraftingTerminalTransferHandler(Class<C> containerClass, IRecipeTransferHandlerHelper helper) {
        this.containerClass = containerClass;
        this.helper = helper;
    }

    public Class<C> getContainerClass() {
        return this.containerClass;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(C container, class_8786<class_3955> recipe, IRecipeSlotsView recipeSlots, class_1657 player, boolean maxTransfer, boolean doTransfer) {
        if (container instanceof IAutoFillTerminal) {
            class_2960 recipeId;
            C term = container;
            if (!term.isSmartSearch() && !doTransfer) {
                return null;
            }
            ArrayList<IRecipeSlotView> missing = new ArrayList<IRecipeSlotView>();
            List views = recipeSlots.getSlotViews();
            ArrayList<class_1799[]> inputs = new ArrayList<class_1799[]>();
            HashSet<StoredItemStack> stored = new HashSet<StoredItemStack>(term.getStoredItems());
            for (IRecipeSlotView view : views) {
                if (view.getRole() != RecipeIngredientRole.INPUT && view.getRole() != RecipeIngredientRole.CATALYST) continue;
                class_1799[] list = (class_1799[])view.getIngredients((IIngredientType)VanillaTypes.ITEM_STACK).toArray(class_1799[]::new);
                if (list.length == 0) {
                    inputs.add(null);
                    continue;
                }
                inputs.add(list);
                boolean found = false;
                for (class_1799 stack : list) {
                    if (stack == null || player.method_31548().method_7395(stack) == -1) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    for (class_1799 stack : list) {
                        StoredItemStack s = new StoredItemStack(stack);
                        if (!stored.contains(s)) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                missing.add(view);
            }
            if (doTransfer && (recipeId = recipe.comp_1932()) != null && !player.method_37908().method_8433().method_8130(recipeId).isEmpty()) {
                class_2487 compound = new class_2487();
                compound.method_10582("fill", recipeId.toString());
                term.sendMessage(compound);
            }
            if (!missing.isEmpty()) {
                return new TransferWarning(this.helper.createUserErrorForMissingSlots((class_2561)class_2561.method_43471((String)"tooltip.toms_storage.items_missing"), missing));
            }
        } else {
            return ERROR_INSTANCE;
        }
        return null;
    }

    public static void registerTransferHandlers(IRecipeTransferRegistration recipeTransferRegistry) {
        recipeTransferRegistry.addRecipeTransferHandler(new CraftingTerminalTransferHandler<CraftingTerminalMenu>(CraftingTerminalMenu.class, recipeTransferRegistry.getTransferHelper()), RecipeTypes.CRAFTING);
    }

    public Optional<class_3917<C>> getMenuType() {
        return Optional.ofNullable(Content.craftingTerminalMenu.get());
    }

    public RecipeType<class_8786<class_3955>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    private static class TransferWarning
    implements IRecipeTransferError {
        private final IRecipeTransferError parent;

        public TransferWarning(IRecipeTransferError parent) {
            this.parent = parent;
        }

        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.COSMETIC;
        }

        public void showError(class_332 guiGraphics, int mouseX, int mouseY, IRecipeSlotsView recipeSlotsView, int recipeX, int recipeY) {
            this.parent.showError(guiGraphics, mouseX, mouseY, recipeSlotsView, recipeX, recipeY);
        }
    }
}

