/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.util;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class PopupMenuManager {
    private final class_437 screen;
    private int x;
    private int y;
    private List<PopupElement> menu;
    private int selected;

    public PopupMenuManager(class_437 screen) {
        this.screen = screen;
    }

    public void open(double x, double y, PopupElement ... menu) {
        this.menu = Arrays.asList(menu);
        this.x = (int)x;
        this.y = (int)y;
        this.selected = -1;
    }

    public void replace(PopupElement ... menu) {
        this.menu = Arrays.asList(menu);
        this.selected = -1;
    }

    public boolean render(class_332 g, class_327 font, int pMouseX, int pMouseY) {
        if (this.menu != null) {
            g.method_51447(font, IntStream.range(0, this.menu.size()).mapToObj(i -> this.menu.get(i).getHoveredText(pMouseX - this.x, pMouseY - this.y - i * 10, this.selected == i)).map(class_2561::method_30937).toList(), this.x - 12, this.y + 12);
        }
        return this.menu == null;
    }

    private static boolean isHovering(int pX, int pY, int pWidth, int pHeight, double pMouseX, double pMouseY) {
        return pMouseX >= (double)(pX - 1) && pMouseX < (double)(pX + pWidth + 1) && pMouseY >= (double)(pY - 1) && pMouseY < (double)(pY + pHeight + 1);
    }

    public boolean mouseClick(double pMouseX, double pMouseY, int pButton) {
        if (this.menu != null) {
            for (int i = 0; i < this.menu.size(); ++i) {
                if (!PopupMenuManager.isHovering(this.x, this.y + i * 10, 100, 8, pMouseX, pMouseY)) continue;
                this.menu.get(i).onClick(pMouseX - (double)this.x, pMouseY - (double)this.y - (double)(i * 10), pButton);
                this.selected = i;
                return true;
            }
            this.menu = null;
            return true;
        }
        return false;
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.menu != null) {
            if (this.selected != -1 && this.menu.get(this.selected).keyPressed(pKeyCode, pScanCode, pModifiers)) {
                return true;
            }
            if (pKeyCode == 264) {
                this.selected = (this.selected + 1) % this.menu.size();
            } else if (pKeyCode == 265) {
                this.selected = (this.selected + this.menu.size() - 1) % this.menu.size();
            } else if (pKeyCode == 256) {
                this.menu = null;
            }
            return true;
        }
        return false;
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        return this.menu != null && this.selected != -1 && this.menu.get(this.selected).charTyped(pCodePoint, pModifiers);
    }

    public void close() {
        this.menu = null;
    }

    public static interface PopupElement {
        public class_5250 getText();

        public void activate();

        default public void onClick(double pMouseX, double pMouseY, int pButton) {
            this.activate();
        }

        default public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
            if (pKeyCode == 257 || pKeyCode == 335) {
                this.activate();
                return true;
            }
            return false;
        }

        default public boolean charTyped(char pCodePoint, int pModifiers) {
            return false;
        }

        default public class_5250 getHoveredText(int pMouseX, int pMouseY, boolean selected) {
            return this.getText().method_27692(PopupMenuManager.isHovering(0, 0, 100, 8, pMouseX, pMouseY) || selected ? class_124.field_1075 : class_124.field_1080);
        }
    }

    public static class TextFieldElement
    implements PopupElement {
        private final Supplier<class_5250> text;
        private final Consumer<String> action;
        private boolean activated;
        private class_342 box;
        private String value;

        public TextFieldElement(Supplier<class_5250> text, Consumer<String> action, class_327 font, String value) {
            this.text = text;
            this.action = action;
            this.box = new class_342(font, 0, 0, 0, 0, null);
            this.value = value;
            this.box.method_1852(value);
            this.box.method_1856(false);
            this.box.method_25365(true);
        }

        @Override
        public class_5250 getText() {
            if (this.activated) {
                StringBuilder sb = new StringBuilder(this.box.method_1882());
                sb.insert(this.box.method_1881(), '_');
                return class_2561.method_43469((String)"tooltip.toms_trading_network.textfield", (Object[])new Object[]{this.text.get(), class_2561.method_43470((String)sb.toString()).method_27692(class_124.field_1054)});
            }
            return class_2561.method_43469((String)"tooltip.toms_trading_network.textfield", (Object[])new Object[]{this.text.get(), class_2561.method_43470((String)this.box.method_1882())});
        }

        @Override
        public void activate() {
            if (this.activated) {
                this.value = this.box.method_1882();
                this.action.accept(this.value);
            }
            this.activated = !this.activated;
        }

        @Override
        public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
            if (this.activated && pKeyCode == 256) {
                this.box.method_1852(this.value);
                this.activated = false;
                return true;
            }
            if (PopupElement.super.keyPressed(pKeyCode, pScanCode, pModifiers)) {
                return true;
            }
            if (this.activated) {
                return this.box.method_25404(pKeyCode, pScanCode, pModifiers);
            }
            return false;
        }

        @Override
        public boolean charTyped(char pCodePoint, int pModifiers) {
            if (this.activated) {
                return this.box.method_25400(pCodePoint, pModifiers);
            }
            return false;
        }
    }

    public static class ButtonElement
    implements PopupElement {
        private final Supplier<class_5250> text;
        private final Runnable action;

        public ButtonElement(Supplier<class_5250> text, Runnable action) {
            this.text = text;
            this.action = action;
        }

        @Override
        public class_5250 getText() {
            return this.text.get();
        }

        @Override
        public void activate() {
            this.action.run();
        }
    }
}

