/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.tom.storagemod.Config;
import com.tom.storagemod.Content;
import com.tom.storagemod.api.MultiblockInventoryAPI;
import com.tom.storagemod.inventory.BlockFilter;
import com.tom.storagemod.inventory.PlatformItemHandler;
import com.tom.storagemod.inventory.VanillaMultiblockInventories;
import com.tom.storagemod.item.ILeftClickListener;
import com.tom.storagemod.item.WirelessTerminal;
import com.tom.storagemod.network.DataPacket;
import com.tom.storagemod.network.OpenTerminalPacket;
import com.tom.storagemod.platform.Platform;
import com.tom.storagemod.platform.PlatformItem;
import com.tom.storagemod.util.IDataReceiver;
import com.tom.storagemod.util.PlayerInvUtil;
import com.tom.storagemod.util.TickerUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Set;
import java.util.function.Function;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerBlockEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3738;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StorageMod
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String modid = "toms_storage";
    public static final Gson gson = new GsonBuilder().create();
    public static ConfigHolder<Config> configHolder = AutoConfig.register(Config.class, GsonConfigSerializer::new);
    private static Config LOADED_CONFIG = (Config)configHolder.getConfig();
    public static Config CONFIG = new Config();
    public static final AttachmentType<BlockFilter> BLOCK_FILTER = AttachmentRegistry.createPersistent((class_2960)class_2960.method_43902((String)"toms_storage", (String)"block_filter"), BlockFilter.CODEC);
    public static boolean polymorph;
    public static Set<class_2248> blockedBlocks;

    public static class_2960 id(String id) {
        return class_2960.method_43902((String)modid, (String)id);
    }

    public void onInitialize() {
        LOGGER.info("Tom's Storage Setup starting");
        Content.init();
        Platform.DATA_COMPONENT_TYPES.runRegistration();
        Platform.BLOCKS.runRegistration();
        Platform.ITEMS.runRegistration();
        Platform.BLOCK_ENTITY.runRegistration();
        Platform.MENU_TYPE.runRegistration();
        PayloadTypeRegistry.playS2C().register(DataPacket.ID, DataPacket.STREAM_CODEC);
        PayloadTypeRegistry.playC2S().register(DataPacket.ID, DataPacket.STREAM_CODEC);
        ServerPlayNetworking.registerGlobalReceiver(DataPacket.ID, (p, c) -> {
            class_1703 patt0$temp = c.player().field_7512;
            if (patt0$temp instanceof IDataReceiver) {
                IDataReceiver d = (IDataReceiver)patt0$temp;
                d.receive(p.tag());
            }
        });
        PayloadTypeRegistry.playC2S().register(OpenTerminalPacket.ID, OpenTerminalPacket.STREAM_CODEC);
        ServerPlayNetworking.registerGlobalReceiver(OpenTerminalPacket.ID, (p, c) -> {
            class_1799 t = PlayerInvUtil.findItem((class_1657)c.player(), i -> {
                WirelessTerminal e;
                class_1792 patt0$temp = i.method_7909();
                return patt0$temp instanceof WirelessTerminal && (e = (WirelessTerminal)patt0$temp).canOpen((class_1799)i);
            }, class_1799.field_8037, Function.identity());
            if (!t.method_7960()) {
                ((WirelessTerminal)t.method_7909()).open((class_1657)c.player(), t);
            }
        });
        ServerLoginNetworking.registerGlobalReceiver((class_2960)StorageMod.id("config"), (server, handler, understood, buf, sync, respSender) -> {});
        ServerLoginConnectionEvents.QUERY_START.register((handler, server, sender, sync) -> {
            class_2540 packet = PacketByteBufs.create();
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new ByteBufOutputStream((ByteBuf)packet));){
                gson.toJson((Object)LOADED_CONFIG, (Appendable)writer);
            }
            catch (IOException e) {
                LOGGER.warn("Error sending config sync", (Throwable)e);
            }
            sender.sendPacket(StorageMod.id("config"), packet);
        });
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            CONFIG = LOADED_CONFIG;
            blockedBlocks = null;
        });
        ItemStorage.SIDED.registerForBlockEntity((be, side) -> PlatformItemHandler.of(be), (class_2591)Content.connectorBE.get());
        ItemStorage.SIDED.registerForBlockEntity((be, side) -> PlatformItemHandler.of(be), (class_2591)Content.invInterfaceBE.get());
        ItemStorage.SIDED.registerForBlockEntity((be, side) -> InventoryStorage.of((class_1263)be.getInv(), (class_2350)side), (class_2591)Content.filingCabinetBE.get());
        ItemStorage.SIDED.registerForBlockEntity((be, side) -> PlatformItemHandler.of(be), (class_2591)Content.invProxyBE.get());
        class_2960 at = class_2960.method_43902((String)modid, (String)"left_click_item_on_block");
        class_2960 rl = class_2960.method_43902((String)modid, (String)"use_item_first");
        AttackBlockCallback.EVENT.register(at, (player, world, hand, pos, direction) -> {
            ILeftClickListener l;
            class_1799 is = player.method_5998(hand);
            class_1792 patt0$temp = is.method_7909();
            if (patt0$temp instanceof ILeftClickListener && (l = (ILeftClickListener)patt0$temp).onLeftClick(is, pos, player)) {
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
        AttackBlockCallback.EVENT.addPhaseOrdering(Event.DEFAULT_PHASE, at);
        UseBlockCallback.EVENT.register(rl, (player, world, hand, hitResult) -> {
            class_2338 pos = hitResult.method_17777();
            class_1799 is = player.method_5998(hand);
            class_1792 patt0$temp = is.method_7909();
            if (patt0$temp instanceof PlatformItem) {
                PlatformItem l = (PlatformItem)patt0$temp;
                return l.onRightClick(player, is, pos, hand);
            }
            return class_1269.field_5811;
        });
        UseBlockCallback.EVENT.addPhaseOrdering(Event.DEFAULT_PHASE, rl);
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, entity) -> {
            BlockFilter bf;
            if (entity != null && (bf = (BlockFilter)entity.getAttachedOrElse(BLOCK_FILTER, null)) != null) {
                bf.dropContents((class_1936)world, pos);
                entity.removeAttached(BLOCK_FILTER);
            }
        });
        ServerBlockEntityEvents.BLOCK_ENTITY_LOAD.register((be, w) -> {
            if (be instanceof TickerUtil.OnLoadListener) {
                TickerUtil.OnLoadListener l = (TickerUtil.OnLoadListener)be;
                w.method_8503().method_63588((Runnable)new class_3738(0, () -> l.onLoad()));
            }
        });
        polymorph = FabricLoader.getInstance().isModLoaded("polymorph");
        configHolder.registerSaveListener((a, b) -> {
            blockedBlocks = null;
            return class_1269.field_5811;
        });
        MultiblockInventoryAPI.EVENT.register(VanillaMultiblockInventories::checkChest);
    }
}

