/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block.entity;

import com.tom.storagemod.Config;
import com.tom.storagemod.Content;
import com.tom.storagemod.block.AbstractInventoryHopperBlock;
import com.tom.storagemod.block.entity.AbstractInventoryHopperBlockEntity;
import com.tom.storagemod.inventory.IInventoryAccess;
import com.tom.storagemod.inventory.InventorySlot;
import com.tom.storagemod.inventory.StoredItemStack;
import com.tom.storagemod.inventory.filter.ItemPredicate;
import com.tom.storagemod.item.IItemFilter;
import com.tom.storagemod.util.BlockFaceReference;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_7225;

public class BasicInventoryHopperBlockEntity
extends AbstractInventoryHopperBlockEntity {
    private class_1799 filter = class_1799.field_8037;
    private int cooldown;
    private long topChange;
    private long bottomChange;
    public int waiting = 0;
    private ItemPredicate filterPred;
    private InventorySlot topSlot;

    public BasicInventoryHopperBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)Content.basicInvHopperBE.get(), pos, state);
    }

    public void method_11007(class_2487 compound, class_7225.class_7874 provider) {
        super.method_11007(compound, provider);
        class_1799 is = this.getFilter();
        if (!is.method_7960()) {
            compound.method_10566("Filter", is.method_57376(provider, (class_2520)new class_2487()));
        }
    }

    public void method_11014(class_2487 nbtIn, class_7225.class_7874 provider) {
        super.method_11014(nbtIn, provider);
        this.filter = class_1799.method_57359((class_7225.class_7874)provider, (class_2487)nbtIn.method_10562("Filter"));
    }

    public void setFilter(class_1799 filter) {
        this.filter = filter;
        if (this.filter.method_7960()) {
            this.filterPred = null;
        } else {
            class_1792 class_17922 = this.filter.method_7909();
            if (class_17922 instanceof IItemFilter) {
                IItemFilter i = (IItemFilter)class_17922;
                this.filterPred = i.createFilter(BlockFaceReference.touching(this.field_11863, this.field_11867, (class_2350)this.method_11010().method_11654(AbstractInventoryHopperBlock.FACING)), filter);
            } else {
                this.filterPred = s -> class_1799.method_31577((class_1799)s.getStack(), (class_1799)filter);
            }
        }
        this.waiting = 0;
        this.method_5431();
    }

    public class_1799 getFilter() {
        return this.filter;
    }

    @Override
    public void updateServer() {
        boolean topWasNull;
        boolean hasFilter;
        if (!this.filter.method_7960() && this.filterPred == null) {
            this.setFilter(this.filter);
        }
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        class_2350 facing = (class_2350)state.method_11654(AbstractInventoryHopperBlock.FACING);
        IInventoryAccess top = this.topCache.getAccess(this.field_11863, this.field_11867.method_10093(facing.method_10153()));
        IInventoryAccess bottom = this.bottomCache.getAccess(this.field_11863, this.field_11867.method_10093(facing));
        boolean topNet = this.topCache.isNetwork();
        if (!this.topCache.isValid() || !this.bottomCache.isValid()) {
            return;
        }
        if (!topNet && !this.bottomCache.isNetwork()) {
            return;
        }
        int baseCd = Math.max(1, Config.get().basicHopperCooldown);
        int midCd = Math.max(1, baseCd * 4 / 10);
        int fastCd = Math.max(1, baseCd / 10);
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        boolean bl = hasFilter = this.filterPred != null;
        if (topNet && !hasFilter) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        IInventoryAccess.IInventoryChangeTracker tt = top.tracker();
        long t = tt.getChangeTracker(this.field_11863);
        if (this.topChange != t) {
            this.topChange = t;
            this.waiting = 0;
            this.topSlot = null;
        } else {
            this.cooldown = midCd;
        }
        if (this.waiting == 1) {
            return;
        }
        IInventoryAccess.IInventoryChangeTracker bt = bottom.tracker();
        long b = bt.getChangeTracker(this.field_11863);
        if (this.bottomChange != b) {
            this.bottomChange = b;
            this.waiting = 0;
        } else {
            this.cooldown = midCd;
        }
        if (this.waiting == 2) {
            return;
        }
        boolean bl2 = topWasNull = this.topSlot == null;
        if (hasFilter) {
            this.filterPred.updateState();
        }
        if (this.topSlot == null || this.waiting == 3) {
            this.topSlot = tt.findSlotAfter(this.topSlot, hasFilter ? this.filterPred : s -> true, false, true);
        }
        if (this.topSlot == null) {
            if (topWasNull) {
                this.waiting = 1;
                this.cooldown = baseCd;
            } else {
                this.cooldown = midCd;
            }
            return;
        }
        class_1799 is = this.topSlot.getStack();
        if (is.method_7960()) {
            this.waiting = 3;
            this.cooldown = fastCd;
            return;
        }
        StoredItemStack st = new StoredItemStack(is);
        if (hasFilter && !this.filterPred.test(st)) {
            this.waiting = 3;
            this.cooldown = fastCd;
            return;
        }
        InventorySlot bottomSlot = bt.findSlotDest(st);
        if (bottomSlot == null) {
            this.waiting = 3;
            this.cooldown = baseCd;
            return;
        }
        if (this.topSlot.transferTo(1, bottomSlot)) {
            this.cooldown = baseCd;
        } else {
            this.waiting = 3;
            this.cooldown = baseCd;
        }
    }
}

