/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.inventory;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tom.storagemod.StorageTags;
import com.tom.storagemod.inventory.IInventoryAccess;
import com.tom.storagemod.inventory.PlatformFilteredInventoryAccess;
import com.tom.storagemod.inventory.PlatformInventoryAccess;
import com.tom.storagemod.inventory.VanillaMultiblockInventories;
import com.tom.storagemod.inventory.filter.IFilter;
import com.tom.storagemod.inventory.filter.ItemFilter;
import com.tom.storagemod.inventory.filter.ItemPredicate;
import com.tom.storagemod.item.IItemFilter;
import com.tom.storagemod.util.BlockFaceReference;
import com.tom.storagemod.util.Priority;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1277;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;

public class BlockFilter
implements IFilter {
    private class_2338 pos;
    private class_2350 side;
    private Set<class_2338> connected;
    public class_1277 filter = new class_1277(1);
    private boolean skip;
    private boolean keepLast;
    private Priority priority;
    private ItemFilter itemFilter = ItemFilter.TRUE;
    private boolean filterNeedsUpdate = true;
    private boolean multiblockFilled;
    public static final Codec<BlockFilterState> STATE_CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)class_2338.field_25064.fieldOf("pos").forGetter(BlockFilterState::pos), (App)Codec.list((Codec)class_2338.field_25064).fieldOf("connected").forGetter(BlockFilterState::connected), (App)Codec.BOOL.fieldOf("skip").forGetter(BlockFilterState::skip), (App)class_2350.field_29502.fieldOf("side").forGetter(BlockFilterState::side), (App)class_1799.field_49266.fieldOf("filter").forGetter(BlockFilterState::filter), (App)Priority.CODEC.fieldOf("priority").forGetter(BlockFilterState::priority), (App)Codec.BOOL.fieldOf("keep_last").forGetter(BlockFilterState::keepLast)).apply((Applicative)b, BlockFilterState::new)).codec();
    public static final Codec<BlockFilter> CODEC = STATE_CODEC.xmap(BlockFilter::new, BlockFilter::storeState);

    public BlockFilter(class_2338 pos) {
        this.pos = pos;
        this.side = class_2350.field_11033;
        this.priority = Priority.NORMAL;
        this.connected = new HashSet<class_2338>();
        this.connected.add(pos);
        this.filter.method_5489(__ -> this.markFilterDirty());
    }

    public BlockFilter(BlockFilterState state) {
        this.pos = state.pos();
        this.loadFromState(state);
        this.filter.method_5489(__ -> this.markFilterDirty());
    }

    public void loadFromState(BlockFilterState state) {
        this.connected = new HashSet<class_2338>(state.connected());
        this.skip = state.skip();
        this.side = state.side();
        this.filter.method_5447(0, state.filter());
        this.priority = state.priority();
        this.keepLast = state.keepLast();
        this.multiblockFilled = true;
    }

    public Set<class_2338> getConnectedBlocks() {
        return this.connected;
    }

    public class_2338 getMainPos() {
        return this.pos;
    }

    public class_2350 getSide() {
        return this.side;
    }

    public BlockFilterState storeState() {
        return new BlockFilterState(this.pos, new ArrayList<class_2338>(this.connected), this.skip, this.side, this.filter.method_5438(0).method_7972(), this.priority, this.keepLast);
    }

    public void dropContents(class_1936 level, class_2338 pos2) {
        if (level instanceof class_1937) {
            class_1937 lvl = (class_1937)level;
            this.filter.method_24514().forEach(f -> class_2248.method_9577((class_1937)lvl, (class_2338)pos2, (class_1799)f));
        }
    }

    public IInventoryAccess wrap(class_1937 level, IInventoryAccess acc) {
        Object f;
        class_1799 filter = this.filter.method_5438(0);
        if (this.filterNeedsUpdate || !this.itemFilter.configMatch(filter)) {
            class_1792 class_17922 = filter.method_7909();
            if (class_17922 instanceof IItemFilter) {
                f = (IItemFilter)class_17922;
                this.itemFilter = f.createFilter(new BlockFaceReference(level, this.pos, this.side), filter);
            } else {
                this.itemFilter = ItemFilter.TRUE;
            }
            this.filterNeedsUpdate = false;
        }
        if (acc instanceof PlatformFilteredInventoryAccess) {
            f = (PlatformFilteredInventoryAccess)acc;
            IFilter.MultiFilter mf = new IFilter.MultiFilter(((PlatformFilteredInventoryAccess)f).getFilter(), this);
            return new PlatformFilteredInventoryAccess(((PlatformFilteredInventoryAccess)f).getActualInventory(), mf);
        }
        return new PlatformFilteredInventoryAccess(acc, this);
    }

    public boolean skip() {
        return this.skip;
    }

    public static BlockFilter findBlockFilterAt(class_1937 level, class_2338 pos) {
        return class_2338.method_29715((class_238)new class_238(pos).method_1014(8.0)).map(p -> BlockFilter.getFilterAt(level, p)).filter(p -> p != null && p.getConnectedBlocks().contains(pos)).findFirst().orElseGet(() -> {
            if (level.method_8320(pos).method_26164(StorageTags.INV_CONFIG_SKIP)) {
                return null;
            }
            return BlockFilter.getOrCreateFilterAt(level, pos);
        });
    }

    public static BlockFilter getFilterAt(class_1937 level, class_2338 pos) {
        return PlatformInventoryAccess.getBlockFilterAt(level, pos, false);
    }

    public static BlockFilter getOrCreateFilterAt(class_1937 level, class_2338 pos) {
        BlockFilter f = PlatformInventoryAccess.getBlockFilterAt(level, pos, true);
        if (f != null) {
            f.fillMultiblock(level);
        }
        return f;
    }

    @Override
    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    @Override
    public ItemPredicate getItemPred() {
        return this.itemFilter;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setSide(class_2350 side) {
        this.side = side;
    }

    public void addConnected(class_1937 level, class_2338 pos) {
        if (!this.pos.equals((Object)pos)) {
            PlatformInventoryAccess.removeBlockFilterAt(level, pos);
        }
        this.connected.add(pos.method_10062());
    }

    @Override
    public boolean isKeepLast() {
        return this.keepLast;
    }

    public void setKeepLast(boolean keepLast) {
        this.keepLast = keepLast;
    }

    public void markFilterDirty() {
        this.filterNeedsUpdate = true;
    }

    private void fillMultiblock(class_1937 level) {
        if (this.multiblockFilled) {
            return;
        }
        VanillaMultiblockInventories.checkChest(level, this.pos, level.method_8320(this.pos), p -> this.addConnected(level, (class_2338)p));
        this.multiblockFilled = true;
    }

    public String toString() {
        return "BlockFilter@" + String.valueOf(this.pos);
    }

    public record BlockFilterState(class_2338 pos, List<class_2338> connected, boolean skip, class_2350 side, class_1799 filter, Priority priority, boolean keepLast) {
    }
}

