/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.InputConstants;
import com.tom.storagemod.Content;
import com.tom.storagemod.block.entity.PaintedBlockEntity;
import com.tom.storagemod.client.BakedPaintedModel;
import com.tom.storagemod.client.ClientUtil;
import com.tom.storagemod.client.CustomRenderTypes;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.platform.GameObject;
import com.tom.storagemod.screen.CraftingTerminalScreen;
import com.tom.storagemod.screen.FilingCabinetScreen;
import com.tom.storagemod.screen.InventoryConfiguratorScreen;
import com.tom.storagemod.screen.InventoryLinkScreen;
import com.tom.storagemod.screen.ItemFilterScreen;
import com.tom.storagemod.screen.LevelEmitterScreen;
import com.tom.storagemod.screen.StorageTerminalScreen;
import com.tom.storagemod.screen.TagItemFilterScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.irisshaders.iris.pipeline.IrisPipelines;
import net.irisshaders.iris.pipeline.programs.ShaderKey;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterRenderPipelinesEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

public class StorageModClient {
    public static KeyMapping openTerm;
    public static List<RenderPipeline> pipelines;
    public static final ResourceLocation CONFIGURATOR_OVERLAY_ID;

    public static void preInit(ModContainer mc, IEventBus bus) {
        bus.addListener(StorageModClient::registerColors);
        bus.addListener(StorageModClient::initKeybinds);
        bus.addListener(StorageModClient::bakeModels);
        bus.addListener(StorageModClient::registerScreens);
        bus.addListener(StorageModClient::registerPipelines);
        bus.addListener(StorageModClient::registerOverlays);
        mc.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    private static void registerScreens(RegisterMenuScreensEvent e) {
        e.register(Content.storageTerminalMenu.get(), StorageTerminalScreen::new);
        e.register(Content.craftingTerminalMenu.get(), CraftingTerminalScreen::new);
        e.register(Content.levelEmitterMenu.get(), LevelEmitterScreen::new);
        e.register(Content.inventoryLink.get(), InventoryLinkScreen::new);
        e.register(Content.itemFilterMenu.get(), ItemFilterScreen::new);
        e.register(Content.tagItemFilterMenu.get(), TagItemFilterScreen::new);
        e.register(Content.invConfigMenu.get(), InventoryConfiguratorScreen::new);
        e.register(Content.filingCabinetMenu.get(), FilingCabinetScreen::new);
    }

    public static void clientSetup() {
        NeoForge.EVENT_BUS.register(StorageModClient.class);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)Content.paintedTrim.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)Content.invCableFramed.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)Content.invProxy.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)Content.invCableConnectorFramed.get()), (RenderType)RenderType.translucent());
    }

    public static void registerOverlays(RegisterGuiLayersEvent event) {
        event.registerAboveAll(CONFIGURATOR_OVERLAY_ID, StorageModClient::renderConfiguratorOverlay);
    }

    public static void renderConfiguratorOverlay(GuiGraphics gr, DeltaTracker p_348559_) {
        ClientUtil.drawConfiguratorOverlay(gr);
    }

    @SubscribeEvent
    public static void getTooltip(ItemTooltipEvent evt) {
        ClientUtil.collectExtraTooltips(evt.getItemStack(), evt.getToolTip());
    }

    private static void initKeybinds(RegisterKeyMappingsEvent evt) {
        openTerm = new KeyMapping("key.toms_storage.open_terminal", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM.getOrCreate(66), "key.categories.gameplay");
        evt.register(openTerm);
    }

    private static void registerColors(RegisterColorHandlersEvent.Block event) {
        event.register(StorageModClient::getColor, new Block[]{(Block)Content.paintedTrim.get(), (Block)Content.invCableFramed.get(), (Block)Content.invProxy.get(), (Block)Content.invCableConnectorFramed.get()});
    }

    private static int getColor(BlockState state, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos, int tintIndex) {
        if (world != null) {
            try {
                BlockState mimicBlock = ((PaintedBlockEntity)world.getBlockEntity(pos)).getPaintedBlockState();
                return Minecraft.getInstance().getBlockColors().getColor(mimicBlock, world, pos, tintIndex);
            }
            catch (Exception var8) {
                return -1;
            }
        }
        return -1;
    }

    private static void bakeModels(ModelEvent.ModifyBakingResult event) {
        StorageModClient.bindPaintedModel(event, Content.paintedTrim);
        StorageModClient.bindPaintedModel(event, Content.invCableFramed);
        StorageModClient.bindPaintedModel(event, Content.invProxy);
        StorageModClient.bindPaintedModel(event, Content.invCableConnectorFramed);
    }

    private static void bindPaintedModel(ModelEvent.ModifyBakingResult event, GameObject<? extends Block> block) {
        block.get().getStateDefinition().getPossibleStates().forEach(st -> {
            Map models = event.getBakingResult().blockStateModels();
            models.put(st, new BakedPaintedModel((Block)block.get(), (BlockStateModel)models.get(st)));
        });
    }

    @SubscribeEvent
    public static void renderWorldOutline(RenderLevelStageEvent evt) {
        if (evt.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            ClientUtil.drawTerminalOutline(evt.getPoseStack());
            ClientUtil.drawConfiguratorOutline(evt.getPoseStack());
        }
    }

    @SubscribeEvent
    public static void clientTick(ClientTickEvent.Post evt) {
        if (Minecraft.getInstance().player == null) {
            return;
        }
        if (openTerm.consumeClick()) {
            NetworkHandler.openTerminal();
        }
    }

    private static void registerPipelines(RegisterRenderPipelinesEvent event) {
        CustomRenderTypes.linesNoDepth();
        pipelines.forEach(arg_0 -> ((RegisterRenderPipelinesEvent)event).registerPipeline(arg_0));
    }

    public static Supplier<RenderPipeline> registerPipeline(Supplier<RenderPipeline> factory) {
        RenderPipeline pipeline = factory.get();
        pipelines.add(pipeline);
        if (ModList.get().isLoaded("iris")) {
            IrisPipelines.assignPipeline((RenderPipeline)pipeline, (ShaderKey)ShaderKey.LINES);
        }
        return () -> pipeline;
    }

    static {
        pipelines = new ArrayList<RenderPipeline>();
        CONFIGURATOR_OVERLAY_ID = ResourceLocation.tryBuild((String)"toms_storage", (String)"configurator_info");
    }
}

