/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block;

import com.tom.storagemod.block.BlockWithTooltip;
import com.tom.storagemod.block.IInventoryCable;
import com.tom.storagemod.block.entity.StorageTerminalBlockEntity;
import com.tom.storagemod.util.BlockFace;
import com.tom.storagemod.util.TickerUtil;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractStorageTerminalBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
IInventoryCable,
BlockWithTooltip {
    public static final EnumProperty<TerminalPos> TERMINAL_POS = EnumProperty.create((String)"pos", TerminalPos.class);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE_N = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)6.0);
    private static final VoxelShape SHAPE_S = Block.box((double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_E = Block.box((double)10.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_W = Block.box((double)0.0, (double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_U = Block.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_D = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);

    public AbstractStorageTerminalBlock(BlockBehaviour.Properties pr) {
        super(pr);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(TERMINAL_POS, (Comparable)((Object)TerminalPos.CENTER))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public RenderShape getRenderShape(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, TERMINAL_POS});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity_1 = world.getBlockEntity(pos);
        if (blockEntity_1 instanceof StorageTerminalBlockEntity) {
            StorageTerminalBlockEntity term = (StorageTerminalBlockEntity)blockEntity_1;
            if (term.canInteractWith(player, false)) {
                player.openMenu((MenuProvider)term);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"chat.toms_storage.terminal_out_of_range"), true);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace().getOpposite();
        FluidState ifluidstate = context.getLevel().getFluidState(context.getClickedPos());
        TerminalPos pos = TerminalPos.CENTER;
        if (direction.getAxis() == Direction.Axis.Y) {
            if (direction == Direction.UP) {
                pos = TerminalPos.UP;
            }
            if (direction == Direction.DOWN) {
                pos = TerminalPos.DOWN;
            }
            direction = context.getHorizontalDirection();
        }
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)(direction.getAxis() == Direction.Axis.Y ? Direction.NORTH : direction))).setValue(TERMINAL_POS, (Comparable)((Object)pos))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected BlockState updateShape(BlockState stateIn, LevelReader levelReader, ScheduledTickAccess scheduledTickAccess, BlockPos blockPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource randomSource) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(blockPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(levelReader));
        }
        return super.updateShape(stateIn, levelReader, scheduledTickAccess, blockPos, facing, facingPos, facingState, randomSource);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch (((TerminalPos)((Object)state.getValue(TERMINAL_POS))).ordinal()) {
            case 0: {
                switch ((Direction)state.getValue(FACING)) {
                    case NORTH: {
                        return SHAPE_N;
                    }
                    case SOUTH: {
                        return SHAPE_S;
                    }
                    case EAST: {
                        return SHAPE_E;
                    }
                    case WEST: {
                        return SHAPE_W;
                    }
                }
                break;
            }
            case 1: {
                return SHAPE_U;
            }
            case 2: {
                return SHAPE_D;
            }
        }
        return SHAPE_N;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return TickerUtil.createTicker(world, false, true);
    }

    @Override
    public boolean canConnectFrom(BlockState state, Direction dir) {
        Direction d = (Direction)state.getValue(FACING);
        TerminalPos p = (TerminalPos)((Object)state.getValue(TERMINAL_POS));
        if (p == TerminalPos.UP) {
            d = Direction.UP;
        }
        if (p == TerminalPos.DOWN) {
            d = Direction.DOWN;
        }
        return dir == d;
    }

    @Override
    public List<BlockFace> nextScan(Level world, BlockState state, BlockPos pos) {
        Direction d = (Direction)state.getValue(FACING);
        TerminalPos p = (TerminalPos)((Object)state.getValue(TERMINAL_POS));
        if (p == TerminalPos.UP) {
            d = Direction.UP;
        }
        if (p == TerminalPos.DOWN) {
            d = Direction.DOWN;
        }
        return Collections.singletonList(new BlockFace(pos.relative(d), d.getOpposite()));
    }

    public static enum TerminalPos implements StringRepresentable
    {
        CENTER("center"),
        UP("up"),
        DOWN("down");

        private String name;

        private TerminalPos(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

