/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.inventory;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tom.storagemod.components.WorldPos;
import com.tom.storagemod.inventory.IInventoryLink;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public class RemoteConnections
extends SavedData {
    private static final String ID = "toms_storage_rc";
    public static final Codec<RemoteConnections> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)Codec.list(Connection.CODEC).fieldOf("connections").forGetter(RemoteConnections::connections)).apply((Applicative)b, RemoteConnections::new)).codec();
    private static final SavedDataType<RemoteConnections> FACTORY = new SavedDataType("toms_storage_rc", RemoteConnections::new, __ -> CODEC, DataFixTypes.LEVEL);
    private Map<UUID, Channel> connections = new HashMap<UUID, Channel>();

    private RemoteConnections(SavedData.Context ctx) {
    }

    private RemoteConnections(List<Connection> conns) {
        for (Connection connection : conns) {
            this.connections.put(connection.channelId(), new Channel(connection));
        }
    }

    private List<Connection> connections() {
        return this.connections.entrySet().stream().map(Connection::new).toList();
    }

    public static RemoteConnections get(Level world) {
        ServerLevel sw = (ServerLevel)world;
        return (RemoteConnections)sw.getServer().overworld().getDataStorage().computeIfAbsent(FACTORY);
    }

    public Channel getChannel(UUID connection) {
        return this.connections.get(connection);
    }

    public UUID makeChannel(String name, boolean isPublic, Player owner) {
        UUID id = UUID.randomUUID();
        if (((String)name).isEmpty() || ((String)name).length() > 50) {
            name = "Channel " + System.currentTimeMillis();
        }
        this.connections.put(id, new Channel(owner.getGameProfile().getId(), owner.getGameProfile().getName(), isPublic, (String)name));
        this.setDirty();
        return id;
    }

    public void removeChannel(UUID id, UUID player) {
        Channel c = this.connections.get(id);
        if (c != null && c.owner.equals(player)) {
            this.connections.remove(id);
            this.setDirty();
        }
    }

    public void editChannel(UUID id, boolean pub, UUID player) {
        Channel c = this.connections.get(id);
        if (c != null && c.owner.equals(player)) {
            c.publicChannel = pub;
            this.setDirty();
        }
    }

    public void invalidateCache(UUID id) {
        Channel c = this.connections.get(id);
        if (c != null) {
            c.connectors.clear();
        }
    }

    public Stream<Map.Entry<UUID, Channel>> streamChannels(Player player) {
        return this.connections.entrySet().stream().filter(c -> ((Channel)c.getValue()).canAccess(player));
    }

    private record Connection(UUID channelId, UUID owner, String ownerName, String displayName, boolean isPublic) {
        public static final Codec<Connection> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)UUIDUtil.CODEC.fieldOf("id").forGetter(Connection::channelId), (App)UUIDUtil.CODEC.fieldOf("owner").forGetter(Connection::owner), (App)Codec.STRING.fieldOf("owner_name").forGetter(Connection::ownerName), (App)Codec.STRING.fieldOf("name").forGetter(Connection::displayName), (App)Codec.BOOL.fieldOf("public").forGetter(Connection::isPublic)).apply((Applicative)b, Connection::new)).codec();

        public Connection(Map.Entry<UUID, Channel> e) {
            this(e.getKey(), e.getValue().owner, e.getValue().ownerName, e.getValue().displayName, e.getValue().publicChannel);
        }
    }

    public static class Channel {
        public Set<WorldPos> connectors = new HashSet<WorldPos>();
        public UUID owner;
        public String ownerName;
        public boolean publicChannel;
        public String displayName;

        public Channel(UUID owner, String ownerName, boolean publicChannel, String displayName) {
            this.owner = owner;
            this.ownerName = ownerName;
            this.publicChannel = publicChannel;
            this.displayName = displayName;
        }

        private Channel(Connection t) {
            this(t.owner(), t.ownerName(), t.isPublic(), t.displayName());
        }

        public void register(ServerLevel world, BlockPos blockPos) {
            WorldPos pos = new WorldPos((ResourceKey<Level>)world.dimension(), blockPos);
            this.connectors.add(pos);
        }

        public Set<IInventoryLink> findOthers(ServerLevel world, BlockPos blockPos, int lvl) {
            WorldPos pos = new WorldPos((ResourceKey<Level>)world.dimension(), blockPos);
            this.connectors.add(pos);
            HashSet<IInventoryLink> found = new HashSet<IInventoryLink>();
            Iterator<WorldPos> posItr = this.connectors.iterator();
            while (posItr.hasNext()) {
                WorldPos dimPos = posItr.next();
                if (dimPos.equals(pos)) continue;
                BlockEntity te = dimPos.getBlockEntity(world);
                if (te instanceof IInventoryLink) {
                    IInventoryLink link = (IInventoryLink)te;
                    if (!link.isAccessibleFrom(world, blockPos, lvl)) continue;
                    found.add(link);
                    continue;
                }
                posItr.remove();
            }
            return found;
        }

        public boolean canAccess(Player player) {
            return this.publicChannel || this.owner.equals(player.getUUID());
        }
    }
}

