/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.item;

import com.tom.storagemod.Config;
import com.tom.storagemod.Content;
import com.tom.storagemod.StorageTags;
import com.tom.storagemod.client.ClientUtil;
import com.tom.storagemod.components.WorldPos;
import com.tom.storagemod.item.WirelessTerminal;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class AdvWirelessTerminalItem
extends Item
implements WirelessTerminal {
    public AdvWirelessTerminalItem(Item.Properties pr) {
        super(pr);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay p_399753_, Consumer<Component> tooltip, TooltipFlag tooltipFlag) {
        WorldPos pos;
        ClientUtil.tooltip("adv_wireless_terminal", tooltip, Config.get().advWirelessRange);
        if (Config.get().wirelessTermBeaconLvl != -1) {
            ClientUtil.tooltip("adv_wireless_terminal.beacon", false, tooltip, new Object[0]);
            ClientUtil.tooltip("adv_wireless_terminal.beacon1", false, tooltip, Config.get().wirelessTermBeaconLvl);
            if (Config.get().wirelessTermBeaconLvlCrossDim != -1) {
                ClientUtil.tooltip("adv_wireless_terminal.beacon2", false, tooltip, Config.get().wirelessTermBeaconLvlCrossDim);
            }
        }
        if ((pos = (WorldPos)itemStack.get(Content.boundPosComponent.get())) != null) {
            int x = pos.pos().getX();
            int y = pos.pos().getY();
            int z = pos.pos().getZ();
            String dim = pos.dim().location().toString();
            tooltip.accept((Component)Component.translatable((String)"tooltip.toms_storage.adv_wireless_terminal.bound", (Object[])new Object[]{x, y, z, dim}));
        }
        tooltip.accept((Component)Component.translatable((String)"tooltip.toms_storage.adv_wireless_terminal.keybind", (Object[])new Object[]{Component.translatable((String)"tooltip.toms_storage.adv_wireless_terminal.keybind.outline", (Object[])new Object[]{Component.keybind((String)"key.toms_storage.open_terminal")}).withStyle(ChatFormatting.GREEN)}));
    }

    public InteractionResult use(Level worldIn, Player playerIn, InteractionHand handIn) {
        return AdvWirelessTerminalItem.activateTerminal(worldIn, playerIn.getItemInHand(handIn), playerIn, handIn);
    }

    public static InteractionResult activateTerminal(Level worldIn, ItemStack stack, Player playerIn, InteractionHand handIn) {
        WorldPos pos = (WorldPos)stack.get(Content.boundPosComponent.get());
        if (pos != null) {
            if (!worldIn.isClientSide) {
                int x = pos.pos().getX();
                int y = pos.pos().getY();
                int z = pos.pos().getZ();
                ServerLevel termWorld = worldIn.getServer().getLevel(pos.dim());
                if (termWorld.isLoaded(new BlockPos(x, y, z))) {
                    BlockHitResult lookingAt = new BlockHitResult(new Vec3((double)x, (double)y, (double)z), Direction.UP, new BlockPos(x, y, z), true);
                    BlockState state = termWorld.getBlockState(lookingAt.getBlockPos());
                    if (state.is(StorageTags.REMOTE_ACTIVATE)) {
                        InteractionResult r = state.useWithoutItem((Level)termWorld, playerIn, lookingAt);
                        return r;
                    }
                    playerIn.displayClientMessage((Component)Component.translatable((String)"chat.toms_storage.terminal_invalid_block"), true);
                } else {
                    playerIn.displayClientMessage((Component)Component.translatable((String)"chat.toms_storage.terminal_not_loaded"), true);
                }
            } else {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResult useOn(UseOnContext c) {
        if (c.isSecondaryUseActive()) {
            if (!c.getLevel().isClientSide) {
                BlockPos pos = c.getClickedPos();
                BlockState state = c.getLevel().getBlockState(pos);
                if (state.is(StorageTags.REMOTE_ACTIVATE)) {
                    ItemStack stack = c.getItemInHand();
                    stack.applyComponents(DataComponentPatch.builder().set(Content.boundPosComponent.get(), (Object)new WorldPos((ResourceKey<Level>)c.getLevel().dimension(), pos)).build());
                    if (c.getPlayer() != null) {
                        c.getPlayer().displayClientMessage((Component)Component.translatable((String)"chat.toms_storage.terminal_bound"), true);
                    }
                    return InteractionResult.SUCCESS;
                }
            } else {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public int getRange(Player pl, ItemStack stack) {
        return Config.get().advWirelessRange;
    }

    @Override
    public void open(Player sender, ItemStack t) {
        AdvWirelessTerminalItem.activateTerminal(sender.level(), t, sender, InteractionHand.MAIN_HAND);
    }

    @Override
    public boolean canOpen(ItemStack t) {
        return true;
    }
}

