/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.jade;

import com.tom.storagemod.inventory.BlockFilter;
import com.tom.storagemod.jade.JadePlugin;
import com.tom.storagemod.util.Priority;
import java.util.Locale;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public enum InventoryConfigProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    public ResourceLocation getUid() {
        return JadePlugin.INVENTORY_CONFIG;
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        BlockFilter bf = BlockFilter.getFilterAt(accessor.getLevel(), accessor.getPosition());
        if (bf != null) {
            data.putBoolean("bf", true);
            data.putBoolean("skip", bf.skip());
            data.putByte("pr", (byte)bf.getPriority().ordinal());
            ItemStack f = bf.filter.getItem(0);
            if (!f.isEmpty()) {
                data.put("filter", f.save((HolderLookup.Provider)accessor.getLevel().registryAccess()));
            }
        }
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (accessor.getServerData().getBooleanOr("bf", false)) {
            IElementHelper elements = IElementHelper.get();
            boolean skip = accessor.getServerData().getBooleanOr("skip", false);
            ItemStack f = accessor.getServerData().getCompound("filter").flatMap(c -> ItemStack.parse((HolderLookup.Provider)accessor.getLevel().registryAccess(), (Tag)c)).orElse(ItemStack.EMPTY);
            tooltip.add((Component)Component.translatable((String)"tooltip.toms_storage.block_filter"));
            Priority pr = Priority.VALUES[Math.abs(accessor.getServerData().getByteOr("pr", (byte)0)) % Priority.VALUES.length];
            if (skip) {
                tooltip.add((Component)Component.translatable((String)"tooltip.toms_storage.block_filter.skip"));
            } else {
                tooltip.add((Component)Component.translatable((String)("tooltip.toms_storage.priority_" + pr.name().toLowerCase(Locale.ROOT))));
                if (!f.isEmpty()) {
                    if (accessor.showDetails()) {
                        ITooltip t = elements.tooltip();
                        IElement icon = elements.item(f, 1.0f).size(new Vec2(18.0f, 18.0f)).translate(new Vec2(0.0f, -1.0f));
                        icon.message(null);
                        t.add(icon);
                        f.getTooltipLines(Item.TooltipContext.of((Level)accessor.getLevel()), accessor.getPlayer(), (TooltipFlag)TooltipFlag.Default.NORMAL).forEach(arg_0 -> ((ITooltip)t).add(arg_0));
                        BoxStyle.GradientBorder b = BoxStyle.getTransparent().clone();
                        b.borderColor = new int[]{-65536, -65536, -65536, -65536};
                        b.borderWidth = 1.0f;
                        tooltip.add((IElement)elements.box(t, (BoxStyle)b));
                    } else {
                        tooltip.add((Component)Component.translatable((String)"tooltip.toms_storage.block_filter.item", (Object[])new Object[]{f.getHoverName()}));
                    }
                }
            }
        }
    }
}

