/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.menu;

import com.tom.storagemod.item.IItemFilter;
import com.tom.storagemod.menu.slot.FilterSlot;
import com.tom.storagemod.menu.slot.PhantomSlot;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.util.IDataReceiver;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractFilteredMenu
extends AbstractContainerMenu
implements IDataReceiver {
    protected final Inventory pinv;

    protected AbstractFilteredMenu(MenuType<?> type, int wid, Inventory pinv) {
        super(type, wid);
        this.pinv = pinv;
    }

    public ItemStack quickMoveStack(Player player, int slot) {
        return ItemStack.EMPTY;
    }

    public void clicked(int slotId, int dragType, ClickType click, Player player) {
        Slot slot;
        Slot slot2 = slot = slotId > -1 && slotId < this.slots.size() ? (Slot)this.slots.get(slotId) : null;
        if (slot instanceof PhantomSlot) {
            ItemStack s = this.getCarried().copy();
            if (!s.isEmpty()) {
                s.setCount(1);
            }
            slot.set(s);
            return;
        }
        if (slot instanceof FilterSlot) {
            boolean sf;
            ItemStack c = this.getCarried();
            ItemStack s = slot.getItem();
            boolean cf = !c.isEmpty() && c.getItem() instanceof IItemFilter;
            boolean bl = sf = !s.isEmpty() && s.getItem() instanceof IItemFilter;
            if (sf && cf || sf && c.isEmpty()) {
                super.clicked(slotId, dragType, click, player);
                return;
            }
            if (sf) {
                return;
            }
            if (cf) {
                slot.set(ItemStack.EMPTY);
                super.clicked(slotId, dragType, click, player);
                return;
            }
            if (!(c = c.copy()).isEmpty()) {
                c.setCount(1);
            }
            slot.set(c);
            return;
        }
        super.clicked(slotId, dragType, click, player);
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return !(slot instanceof PhantomSlot) && !(slot instanceof FilterSlot);
    }

    public void setPhantom(Slot slot, ItemStack ingredient) {
        CompoundTag tag = new CompoundTag();
        CompoundTag t = new CompoundTag();
        tag.put("setPhantom", (Tag)t);
        t.putInt("id", slot.index);
        t.put("item", ingredient.save((HolderLookup.Provider)this.pinv.player.registryAccess()));
        NetworkHandler.sendDataToServer(tag);
    }

    @Override
    public void receive(CompoundTag tag) {
        if (this.pinv.player.isSpectator()) {
            return;
        }
        tag.getCompound("setPhantom").ifPresent(t -> {
            Slot slot;
            int slotId = t.getIntOr("id", -1);
            ItemStack item = ItemStack.parse((HolderLookup.Provider)this.pinv.player.registryAccess(), (Tag)t.getCompoundOrEmpty("item")).orElse(ItemStack.EMPTY);
            Slot slot2 = slot = slotId > -1 && slotId < this.slots.size() ? (Slot)this.slots.get(slotId) : null;
            if (slot instanceof PhantomSlot) {
                if (!item.isEmpty()) {
                    item.setCount(1);
                    slot.set(item);
                }
            } else if (slot instanceof FilterSlot && !(item.getItem() instanceof IItemFilter)) {
                boolean sf;
                ItemStack s = slot.getItem();
                boolean bl = sf = !s.isEmpty() && s.getItem() instanceof IItemFilter;
                if (!sf && !item.isEmpty()) {
                    item.setCount(1);
                    slot.set(item);
                }
            }
        });
    }
}

