/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.network;

import com.tom.storagemod.item.WirelessTerminal;
import com.tom.storagemod.network.DataPacket;
import com.tom.storagemod.network.OpenTerminalPacket;
import com.tom.storagemod.util.IDataReceiver;
import com.tom.storagemod.util.PlayerInvUtil;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class NetworkHandler {
    @SubscribeEvent
    public static void onPayloadRegister(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playBidirectional(DataPacket.ID, DataPacket.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(NetworkHandler::handleDataClient, NetworkHandler::handleDataServer));
        registrar.playToServer(OpenTerminalPacket.ID, OpenTerminalPacket.STREAM_CODEC, NetworkHandler::handleTermServer);
    }

    public static void handleDataServer(DataPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer sender = (ServerPlayer)context.player();
            if (sender.containerMenu instanceof IDataReceiver) {
                ((IDataReceiver)sender.containerMenu).receive(packet.tag());
            }
        });
    }

    public static void handleDataClient(DataPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (Minecraft.getInstance().screen instanceof IDataReceiver) {
                ((IDataReceiver)Minecraft.getInstance().screen).receive(packet.tag());
            }
        });
    }

    public static void handleTermServer(OpenTerminalPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer sender = (ServerPlayer)context.player();
            ItemStack t = PlayerInvUtil.findItem((Player)sender, i -> {
                WirelessTerminal e;
                Item patt0$temp = i.getItem();
                return patt0$temp instanceof WirelessTerminal && (e = (WirelessTerminal)patt0$temp).canOpen((ItemStack)i);
            }, ItemStack.EMPTY, Function.identity());
            if (!t.isEmpty()) {
                ((WirelessTerminal)t.getItem()).open((Player)sender, t);
            }
        });
    }

    public static void sendDataToServer(CompoundTag tag) {
        PacketDistributor.sendToServer((CustomPacketPayload)new DataPacket(tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendTo(ServerPlayer pl, CompoundTag tag) {
        PacketDistributor.sendToPlayer((ServerPlayer)pl, (CustomPacketPayload)new DataPacket(tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void openTerminal() {
        PacketDistributor.sendToServer((CustomPacketPayload)new OpenTerminalPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

